/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.HostTags;
import com.datadog.api.v1.client.model.TagToHosts;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class TagsApi {
    private ApiClient apiClient;

    public TagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TagsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public HostTags createHostTags(String hostName, HostTags body) throws ApiException {
        return this.createHostTagsWithHttpInfo(hostName, body, new CreateHostTagsOptionalParameters()).getData();
    }

    public HostTags createHostTags(String hostName, HostTags body, CreateHostTagsOptionalParameters parameters) throws ApiException {
        return this.createHostTagsWithHttpInfo(hostName, body, parameters).getData();
    }

    public ApiResponse<HostTags> createHostTagsWithHttpInfo(String hostName, HostTags body, CreateHostTagsOptionalParameters parameters) throws ApiException {
        HostTags localVarPostBody = body;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling createHostTags");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createHostTags");
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        localVarHeaderParams.put("DD-OPERATION-ID", "createHostTags");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<HostTags> localVarReturnType = new GenericType<HostTags>(){};
        return this.apiClient.invokeAPI("TagsApi.createHostTags", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteHostTags(String hostName) throws ApiException {
        this.deleteHostTagsWithHttpInfo(hostName, new DeleteHostTagsOptionalParameters());
    }

    public void deleteHostTags(String hostName, DeleteHostTagsOptionalParameters parameters) throws ApiException {
        this.deleteHostTagsWithHttpInfo(hostName, parameters);
    }

    public ApiResponse<Void> deleteHostTagsWithHttpInfo(String hostName, DeleteHostTagsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling deleteHostTags");
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteHostTags");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("TagsApi.deleteHostTags", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public HostTags getHostTags(String hostName) throws ApiException {
        return this.getHostTagsWithHttpInfo(hostName, new GetHostTagsOptionalParameters()).getData();
    }

    public HostTags getHostTags(String hostName, GetHostTagsOptionalParameters parameters) throws ApiException {
        return this.getHostTagsWithHttpInfo(hostName, parameters).getData();
    }

    public ApiResponse<HostTags> getHostTagsWithHttpInfo(String hostName, GetHostTagsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling getHostTags");
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        localVarHeaderParams.put("DD-OPERATION-ID", "getHostTags");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<HostTags> localVarReturnType = new GenericType<HostTags>(){};
        return this.apiClient.invokeAPI("TagsApi.getHostTags", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TagToHosts listHostTags() throws ApiException {
        return this.listHostTagsWithHttpInfo(new ListHostTagsOptionalParameters()).getData();
    }

    public TagToHosts listHostTags(ListHostTagsOptionalParameters parameters) throws ApiException {
        return this.listHostTagsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<TagToHosts> listHostTagsWithHttpInfo(ListHostTagsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        localVarHeaderParams.put("DD-OPERATION-ID", "listHostTags");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<TagToHosts> localVarReturnType = new GenericType<TagToHosts>(){};
        return this.apiClient.invokeAPI("TagsApi.listHostTags", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public HostTags updateHostTags(String hostName, HostTags body) throws ApiException {
        return this.updateHostTagsWithHttpInfo(hostName, body, new UpdateHostTagsOptionalParameters()).getData();
    }

    public HostTags updateHostTags(String hostName, HostTags body, UpdateHostTagsOptionalParameters parameters) throws ApiException {
        return this.updateHostTagsWithHttpInfo(hostName, body, parameters).getData();
    }

    public ApiResponse<HostTags> updateHostTagsWithHttpInfo(String hostName, HostTags body, UpdateHostTagsOptionalParameters parameters) throws ApiException {
        HostTags localVarPostBody = body;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling updateHostTags");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateHostTags");
        }
        String source = parameters.source;
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        localVarHeaderParams.put("DD-OPERATION-ID", "updateHostTags");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<HostTags> localVarReturnType = new GenericType<HostTags>(){};
        return this.apiClient.invokeAPI("TagsApi.updateHostTags", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class UpdateHostTagsOptionalParameters {
        private String source;

        public UpdateHostTagsOptionalParameters source(String source) {
            this.source = source;
            return this;
        }
    }

    public static class ListHostTagsOptionalParameters {
        private String source;

        public ListHostTagsOptionalParameters source(String source) {
            this.source = source;
            return this;
        }
    }

    public static class GetHostTagsOptionalParameters {
        private String source;

        public GetHostTagsOptionalParameters source(String source) {
            this.source = source;
            return this;
        }
    }

    public static class DeleteHostTagsOptionalParameters {
        private String source;

        public DeleteHostTagsOptionalParameters source(String source) {
            this.source = source;
            return this;
        }
    }

    public static class CreateHostTagsOptionalParameters {
        private String source;

        public CreateHostTagsOptionalParameters source(String source) {
            this.source = source;
            return this;
        }
    }
}

