/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.OrganizationAttributes;
import com.datadog.api.v2.client.model.OrganizationsType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Organization object.")
@JsonPropertyOrder(value={"attributes", "id", "type"})
public class Organization {
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private OrganizationAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private OrganizationsType type = OrganizationsType.ORGS;

    public Organization() {
    }

    @JsonCreator
    public Organization(@JsonProperty(required=true, value="type") OrganizationsType type) {
        this.type = type;
    }

    public Organization attributes(OrganizationAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OrganizationAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(OrganizationAttributes attributes) {
        this.attributes = attributes;
    }

    public Organization id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the organization.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Organization type(OrganizationsType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OrganizationsType getType() {
        return this.type;
    }

    public void setType(OrganizationsType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization organization = (Organization)o;
        return Objects.equals(this.attributes, organization.attributes) && Objects.equals(this.id, organization.id) && Objects.equals((Object)this.type, (Object)organization.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.id, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Organization {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

