/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.ApplicationKeyResponseIncludedItem;
import com.datadog.api.v2.client.model.FullApplicationKey;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response for retrieving an application key.")
@JsonPropertyOrder(value={"data", "included"})
public class ApplicationKeyResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private FullApplicationKey data;
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<ApplicationKeyResponseIncludedItem> included = null;

    public ApplicationKeyResponse data(FullApplicationKey data) {
        this.data = data;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FullApplicationKey getData() {
        return this.data;
    }

    public void setData(FullApplicationKey data) {
        this.data = data;
    }

    public ApplicationKeyResponse included(List<ApplicationKeyResponseIncludedItem> included) {
        this.included = included;
        return this;
    }

    public ApplicationKeyResponse addIncludedItem(ApplicationKeyResponseIncludedItem includedItem) {
        if (this.included == null) {
            this.included = new ArrayList<ApplicationKeyResponseIncludedItem>();
        }
        this.included.add(includedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of objects related to the application key.")
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ApplicationKeyResponseIncludedItem> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<ApplicationKeyResponseIncludedItem> included) {
        this.included = included;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationKeyResponse applicationKeyResponse = (ApplicationKeyResponse)o;
        return Objects.equals(this.data, applicationKeyResponse.data) && Objects.equals(this.included, applicationKeyResponse.included);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationKeyResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

