/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsAPITestConfig;
import com.datadog.api.v1.client.model.SyntheticsAPITestType;
import com.datadog.api.v1.client.model.SyntheticsTestDetailsSubType;
import com.datadog.api.v1.client.model.SyntheticsTestOptions;
import com.datadog.api.v1.client.model.SyntheticsTestPauseStatus;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing details about a Synthetic API test.")
@JsonPropertyOrder(value={"config", "locations", "message", "monitor_id", "name", "options", "public_id", "status", "subtype", "tags", "type"})
public class SyntheticsAPITest {
    public static final String JSON_PROPERTY_CONFIG = "config";
    private SyntheticsAPITestConfig config;
    public static final String JSON_PROPERTY_LOCATIONS = "locations";
    private List<String> locations = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_MONITOR_ID = "monitor_id";
    private Long monitorId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SyntheticsTestOptions options;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SyntheticsTestPauseStatus status;
    public static final String JSON_PROPERTY_SUBTYPE = "subtype";
    private SyntheticsTestDetailsSubType subtype;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsAPITestType type = SyntheticsAPITestType.API;

    public SyntheticsAPITest config(SyntheticsAPITestConfig config) {
        this.config = config;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsAPITestConfig getConfig() {
        return this.config;
    }

    public void setConfig(SyntheticsAPITestConfig config) {
        this.config = config;
    }

    public SyntheticsAPITest locations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public SyntheticsAPITest addLocationsItem(String locationsItem) {
        if (this.locations == null) {
            this.locations = new ArrayList<String>();
        }
        this.locations.add(locationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of locations used to run the test.")
    @JsonProperty(value="locations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public SyntheticsAPITest message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Notification message associated with the test.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Nullable
    @ApiModelProperty(value="The associated monitor ID.")
    @JsonProperty(value="monitor_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMonitorId() {
        return this.monitorId;
    }

    public SyntheticsAPITest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the test.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsAPITest options(SyntheticsTestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestOptions getOptions() {
        return this.options;
    }

    public void setOptions(SyntheticsTestOptions options) {
        this.options = options;
    }

    @Nullable
    @ApiModelProperty(value="The public ID for the test.")
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public SyntheticsAPITest status(SyntheticsTestPauseStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestPauseStatus getStatus() {
        return this.status;
    }

    public void setStatus(SyntheticsTestPauseStatus status) {
        this.status = status;
    }

    public SyntheticsAPITest subtype(SyntheticsTestDetailsSubType subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestDetailsSubType getSubtype() {
        return this.subtype;
    }

    public void setSubtype(SyntheticsTestDetailsSubType subtype) {
        this.subtype = subtype;
    }

    public SyntheticsAPITest tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SyntheticsAPITest addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of tags attached to the test.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SyntheticsAPITest type(SyntheticsAPITestType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsAPITestType getType() {
        return this.type;
    }

    public void setType(SyntheticsAPITestType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsAPITest syntheticsAPITest = (SyntheticsAPITest)o;
        return Objects.equals(this.config, syntheticsAPITest.config) && Objects.equals(this.locations, syntheticsAPITest.locations) && Objects.equals(this.message, syntheticsAPITest.message) && Objects.equals(this.monitorId, syntheticsAPITest.monitorId) && Objects.equals(this.name, syntheticsAPITest.name) && Objects.equals(this.options, syntheticsAPITest.options) && Objects.equals(this.publicId, syntheticsAPITest.publicId) && Objects.equals((Object)this.status, (Object)syntheticsAPITest.status) && Objects.equals((Object)this.subtype, (Object)syntheticsAPITest.subtype) && Objects.equals(this.tags, syntheticsAPITest.tags) && Objects.equals((Object)this.type, (Object)syntheticsAPITest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.config, this.locations, this.message, this.monitorId, this.name, this.options, this.publicId, this.status, this.subtype, this.tags, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsAPITest {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    locations: ").append(this.toIndentedString(this.locations)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    monitorId: ").append(this.toIndentedString(this.monitorId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString((Object)this.subtype)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

