/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.HeatMapWidgetDefinitionType;
import com.datadog.api.v1.client.model.HeatMapWidgetRequest;
import com.datadog.api.v1.client.model.WidgetAxis;
import com.datadog.api.v1.client.model.WidgetCustomLink;
import com.datadog.api.v1.client.model.WidgetEvent;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The heat map visualization shows metrics aggregated across many tags, such as hosts. The more hosts that have a particular value, the darker that square is.")
@JsonPropertyOrder(value={"custom_links", "events", "legend_size", "requests", "show_legend", "time", "title", "title_align", "title_size", "type", "yaxis"})
public class HeatMapWidgetDefinition {
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<WidgetEvent> events = null;
    public static final String JSON_PROPERTY_LEGEND_SIZE = "legend_size";
    private String legendSize;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<HeatMapWidgetRequest> requests = new ArrayList<HeatMapWidgetRequest>();
    public static final String JSON_PROPERTY_SHOW_LEGEND = "show_legend";
    private Boolean showLegend;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private HeatMapWidgetDefinitionType type = HeatMapWidgetDefinitionType.HEATMAP;
    public static final String JSON_PROPERTY_YAXIS = "yaxis";
    private WidgetAxis yaxis;

    public HeatMapWidgetDefinition() {
    }

    @JsonCreator
    public HeatMapWidgetDefinition(@JsonProperty(required=true, value="requests") List<HeatMapWidgetRequest> requests, @JsonProperty(required=true, value="type") HeatMapWidgetDefinitionType type) {
        this.requests = requests;
        this.type = type;
    }

    public HeatMapWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        return this;
    }

    public HeatMapWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of custom links.")
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public HeatMapWidgetDefinition events(List<WidgetEvent> events) {
        this.events = events;
        return this;
    }

    public HeatMapWidgetDefinition addEventsItem(WidgetEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<WidgetEvent>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of widget events.")
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<WidgetEvent> events) {
        this.events = events;
    }

    public HeatMapWidgetDefinition legendSize(String legendSize) {
        this.legendSize = legendSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Available legend sizes for a widget. Should be one of \"0\", \"2\", \"4\", \"8\", \"16\", or \"auto\".")
    @JsonProperty(value="legend_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegendSize() {
        return this.legendSize;
    }

    public void setLegendSize(String legendSize) {
        this.legendSize = legendSize;
    }

    public HeatMapWidgetDefinition requests(List<HeatMapWidgetRequest> requests) {
        this.requests = requests;
        return this;
    }

    public HeatMapWidgetDefinition addRequestsItem(HeatMapWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"q\":\"jvm.heap.memory\"}]", required=true, value="List of widget types.")
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<HeatMapWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<HeatMapWidgetRequest> requests) {
        this.requests = requests;
    }

    public HeatMapWidgetDefinition showLegend(Boolean showLegend) {
        this.showLegend = showLegend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not to display the legend on this widget.")
    @JsonProperty(value="show_legend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(Boolean showLegend) {
        this.showLegend = showLegend;
    }

    public HeatMapWidgetDefinition time(WidgetTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public HeatMapWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public HeatMapWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public HeatMapWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public HeatMapWidgetDefinition type(HeatMapWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HeatMapWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(HeatMapWidgetDefinitionType type) {
        this.type = type;
    }

    public HeatMapWidgetDefinition yaxis(WidgetAxis yaxis) {
        this.yaxis = yaxis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="yaxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetAxis getYaxis() {
        return this.yaxis;
    }

    public void setYaxis(WidgetAxis yaxis) {
        this.yaxis = yaxis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeatMapWidgetDefinition heatMapWidgetDefinition = (HeatMapWidgetDefinition)o;
        return Objects.equals(this.customLinks, heatMapWidgetDefinition.customLinks) && Objects.equals(this.events, heatMapWidgetDefinition.events) && Objects.equals(this.legendSize, heatMapWidgetDefinition.legendSize) && Objects.equals(this.requests, heatMapWidgetDefinition.requests) && Objects.equals(this.showLegend, heatMapWidgetDefinition.showLegend) && Objects.equals(this.time, heatMapWidgetDefinition.time) && Objects.equals(this.title, heatMapWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)heatMapWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, heatMapWidgetDefinition.titleSize) && Objects.equals((Object)this.type, (Object)heatMapWidgetDefinition.type) && Objects.equals(this.yaxis, heatMapWidgetDefinition.yaxis);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customLinks, this.events, this.legendSize, this.requests, this.showLegend, this.time, this.title, this.titleAlign, this.titleSize, this.type, this.yaxis});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HeatMapWidgetDefinition {\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    legendSize: ").append(this.toIndentedString(this.legendSize)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    showLegend: ").append(this.toIndentedString(this.showLegend)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    yaxis: ").append(this.toIndentedString(this.yaxis)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

