/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The GCS archive's integration destination.")
@JsonPropertyOrder(value={"client_email", "project_id"})
public class LogsArchiveIntegrationGCS {
    public static final String JSON_PROPERTY_CLIENT_EMAIL = "client_email";
    private String clientEmail;
    public static final String JSON_PROPERTY_PROJECT_ID = "project_id";
    private String projectId;

    public LogsArchiveIntegrationGCS() {
    }

    @JsonCreator
    public LogsArchiveIntegrationGCS(@JsonProperty(required=true, value="client_email") String clientEmail, @JsonProperty(required=true, value="project_id") String projectId) {
        this.clientEmail = clientEmail;
        this.projectId = projectId;
    }

    public LogsArchiveIntegrationGCS clientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
        return this;
    }

    @ApiModelProperty(example="youremail@example.com", required=true, value="A client email.")
    @JsonProperty(value="client_email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientEmail() {
        return this.clientEmail;
    }

    public void setClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public LogsArchiveIntegrationGCS projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(example="project-id", required=true, value="A project ID.")
    @JsonProperty(value="project_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsArchiveIntegrationGCS logsArchiveIntegrationGCS = (LogsArchiveIntegrationGCS)o;
        return Objects.equals(this.clientEmail, logsArchiveIntegrationGCS.clientEmail) && Objects.equals(this.projectId, logsArchiveIntegrationGCS.projectId);
    }

    public int hashCode() {
        return Objects.hash(this.clientEmail, this.projectId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsArchiveIntegrationGCS {\n");
        sb.append("    clientEmail: ").append(this.toIndentedString(this.clientEmail)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

