/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.APIKeyCreateRequest;
import com.datadog.api.v2.client.model.APIKeyResponse;
import com.datadog.api.v2.client.model.APIKeyUpdateRequest;
import com.datadog.api.v2.client.model.APIKeysResponse;
import com.datadog.api.v2.client.model.APIKeysSort;
import com.datadog.api.v2.client.model.ApplicationKeyCreateRequest;
import com.datadog.api.v2.client.model.ApplicationKeyResponse;
import com.datadog.api.v2.client.model.ApplicationKeyUpdateRequest;
import com.datadog.api.v2.client.model.ApplicationKeysSort;
import com.datadog.api.v2.client.model.ListApplicationKeysResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class KeyManagementApi {
    private ApiClient apiClient;

    public KeyManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public APIKeyResponse createAPIKey(APIKeyCreateRequest body) throws ApiException {
        return this.createAPIKeyWithHttpInfo(body).getData();
    }

    public ApiResponse<APIKeyResponse> createAPIKeyWithHttpInfo(APIKeyCreateRequest body) throws ApiException {
        APIKeyCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAPIKey");
        }
        String localVarPath = "/api/v2/api_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<APIKeyResponse> localVarReturnType = new GenericType<APIKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.createAPIKey", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ApplicationKeyResponse createCurrentUserApplicationKey(ApplicationKeyCreateRequest body) throws ApiException {
        return this.createCurrentUserApplicationKeyWithHttpInfo(body).getData();
    }

    public ApiResponse<ApplicationKeyResponse> createCurrentUserApplicationKeyWithHttpInfo(ApplicationKeyCreateRequest body) throws ApiException {
        ApplicationKeyCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createCurrentUserApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.createCurrentUserApplicationKey", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteAPIKey(String apiKeyId) throws ApiException {
        this.deleteAPIKeyWithHttpInfo(apiKeyId);
    }

    public ApiResponse<Void> deleteAPIKeyWithHttpInfo(String apiKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (apiKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiKeyId' when calling deleteAPIKey");
        }
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("KeyManagementApi.deleteAPIKey", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public void deleteApplicationKey(String appKeyId) throws ApiException {
        this.deleteApplicationKeyWithHttpInfo(appKeyId);
    }

    public ApiResponse<Void> deleteApplicationKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteApplicationKey");
        }
        String localVarPath = "/api/v2/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("KeyManagementApi.deleteApplicationKey", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public void deleteCurrentUserApplicationKey(String appKeyId) throws ApiException {
        this.deleteCurrentUserApplicationKeyWithHttpInfo(appKeyId);
    }

    public ApiResponse<Void> deleteCurrentUserApplicationKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteCurrentUserApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("KeyManagementApi.deleteCurrentUserApplicationKey", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIKeyResponse getAPIKey(String apiKeyId) throws ApiException {
        return this.getAPIKeyWithHttpInfo(apiKeyId, new GetAPIKeyOptionalParameters()).getData();
    }

    public APIKeyResponse getAPIKey(String apiKeyId, GetAPIKeyOptionalParameters parameters) throws ApiException {
        return this.getAPIKeyWithHttpInfo(apiKeyId, parameters).getData();
    }

    public ApiResponse<APIKeyResponse> getAPIKeyWithHttpInfo(String apiKeyId, GetAPIKeyOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (apiKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiKeyId' when calling getAPIKey");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<APIKeyResponse> localVarReturnType = new GenericType<APIKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.getAPIKey", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ApplicationKeyResponse getCurrentUserApplicationKey(String appKeyId) throws ApiException {
        return this.getCurrentUserApplicationKeyWithHttpInfo(appKeyId).getData();
    }

    public ApiResponse<ApplicationKeyResponse> getCurrentUserApplicationKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling getCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getCurrentUserApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.getCurrentUserApplicationKey", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIKeysResponse listAPIKeys() throws ApiException {
        return this.listAPIKeysWithHttpInfo(new ListAPIKeysOptionalParameters()).getData();
    }

    public APIKeysResponse listAPIKeys(ListAPIKeysOptionalParameters parameters) throws ApiException {
        return this.listAPIKeysWithHttpInfo(parameters).getData();
    }

    public ApiResponse<APIKeysResponse> listAPIKeysWithHttpInfo(ListAPIKeysOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        APIKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String filterModifiedAtStart = parameters.filterModifiedAtStart;
        String filterModifiedAtEnd = parameters.filterModifiedAtEnd;
        String include = parameters.include;
        String localVarPath = "/api/v2/api_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[modified_at][start]", filterModifiedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[modified_at][end]", filterModifiedAtEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "listAPIKeys");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<APIKeysResponse> localVarReturnType = new GenericType<APIKeysResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.listAPIKeys", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ListApplicationKeysResponse listApplicationKeys() throws ApiException {
        return this.listApplicationKeysWithHttpInfo(new ListApplicationKeysOptionalParameters()).getData();
    }

    public ListApplicationKeysResponse listApplicationKeys(ListApplicationKeysOptionalParameters parameters) throws ApiException {
        return this.listApplicationKeysWithHttpInfo(parameters).getData();
    }

    public ApiResponse<ListApplicationKeysResponse> listApplicationKeysWithHttpInfo(ListApplicationKeysOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ApplicationKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String localVarPath = "/api/v2/application_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listApplicationKeys");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ListApplicationKeysResponse> localVarReturnType = new GenericType<ListApplicationKeysResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.listApplicationKeys", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ListApplicationKeysResponse listCurrentUserApplicationKeys() throws ApiException {
        return this.listCurrentUserApplicationKeysWithHttpInfo(new ListCurrentUserApplicationKeysOptionalParameters()).getData();
    }

    public ListApplicationKeysResponse listCurrentUserApplicationKeys(ListCurrentUserApplicationKeysOptionalParameters parameters) throws ApiException {
        return this.listCurrentUserApplicationKeysWithHttpInfo(parameters).getData();
    }

    public ApiResponse<ListApplicationKeysResponse> listCurrentUserApplicationKeysWithHttpInfo(ListCurrentUserApplicationKeysOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ApplicationKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String localVarPath = "/api/v2/current_user/application_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listCurrentUserApplicationKeys");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ListApplicationKeysResponse> localVarReturnType = new GenericType<ListApplicationKeysResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.listCurrentUserApplicationKeys", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIKeyResponse updateAPIKey(String apiKeyId, APIKeyUpdateRequest body) throws ApiException {
        return this.updateAPIKeyWithHttpInfo(apiKeyId, body).getData();
    }

    public ApiResponse<APIKeyResponse> updateAPIKeyWithHttpInfo(String apiKeyId, APIKeyUpdateRequest body) throws ApiException {
        APIKeyUpdateRequest localVarPostBody = body;
        if (apiKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiKeyId' when calling updateAPIKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAPIKey");
        }
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<APIKeyResponse> localVarReturnType = new GenericType<APIKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.updateAPIKey", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ApplicationKeyResponse updateApplicationKey(String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        return this.updateApplicationKeyWithHttpInfo(appKeyId, body).getData();
    }

    public ApiResponse<ApplicationKeyResponse> updateApplicationKeyWithHttpInfo(String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationKey");
        }
        String localVarPath = "/api/v2/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.updateApplicationKey", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ApplicationKeyResponse updateCurrentUserApplicationKey(String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        return this.updateCurrentUserApplicationKeyWithHttpInfo(appKeyId, body).getData();
    }

    public ApiResponse<ApplicationKeyResponse> updateCurrentUserApplicationKeyWithHttpInfo(String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateCurrentUserApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateCurrentUserApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.updateCurrentUserApplicationKey", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListCurrentUserApplicationKeysOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private ApplicationKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;

        public ListCurrentUserApplicationKeysOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListCurrentUserApplicationKeysOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListCurrentUserApplicationKeysOptionalParameters sort(ApplicationKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public ListCurrentUserApplicationKeysOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListCurrentUserApplicationKeysOptionalParameters filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public ListCurrentUserApplicationKeysOptionalParameters filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }
    }

    public static class ListApplicationKeysOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private ApplicationKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;

        public ListApplicationKeysOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListApplicationKeysOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListApplicationKeysOptionalParameters sort(ApplicationKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public ListApplicationKeysOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListApplicationKeysOptionalParameters filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public ListApplicationKeysOptionalParameters filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }
    }

    public static class ListAPIKeysOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private APIKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;
        private String filterModifiedAtStart;
        private String filterModifiedAtEnd;
        private String include;

        public ListAPIKeysOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListAPIKeysOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListAPIKeysOptionalParameters sort(APIKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public ListAPIKeysOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListAPIKeysOptionalParameters filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public ListAPIKeysOptionalParameters filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }

        public ListAPIKeysOptionalParameters filterModifiedAtStart(String filterModifiedAtStart) {
            this.filterModifiedAtStart = filterModifiedAtStart;
            return this;
        }

        public ListAPIKeysOptionalParameters filterModifiedAtEnd(String filterModifiedAtEnd) {
            this.filterModifiedAtEnd = filterModifiedAtEnd;
            return this;
        }

        public ListAPIKeysOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetAPIKeyOptionalParameters {
        private String include;

        public GetAPIKeyOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }
}

