/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsBrowserErrorType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Error response object for a browser test.")
@JsonPropertyOrder(value={"description", "name", "statusCode", "type"})
public class SyntheticsBrowserError {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS_CODE = "statusCode";
    private Long statusCode;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsBrowserErrorType type;

    public SyntheticsBrowserError() {
    }

    @JsonCreator
    public SyntheticsBrowserError(@JsonProperty(required=true, value="description") String description, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="type") SyntheticsBrowserErrorType type) {
        this.description = description;
        this.name = name;
        this.type = type;
    }

    public SyntheticsBrowserError description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Description of the error.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SyntheticsBrowserError name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Name of the error.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsBrowserError statusCode(Long statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status Code of the error.")
    @JsonProperty(value="statusCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Long statusCode) {
        this.statusCode = statusCode;
    }

    public SyntheticsBrowserError type(SyntheticsBrowserErrorType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsBrowserErrorType getType() {
        return this.type;
    }

    public void setType(SyntheticsBrowserErrorType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsBrowserError syntheticsBrowserError = (SyntheticsBrowserError)o;
        return Objects.equals(this.description, syntheticsBrowserError.description) && Objects.equals(this.name, syntheticsBrowserError.name) && Objects.equals(this.statusCode, syntheticsBrowserError.statusCode) && Objects.equals((Object)this.type, (Object)syntheticsBrowserError.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.name, this.statusCode, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsBrowserError {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

