/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.NotebookAuthor;
import com.datadog.api.v1.client.model.NotebookCellResponse;
import com.datadog.api.v1.client.model.NotebookGlobalTime;
import com.datadog.api.v1.client.model.NotebookStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The attributes of a notebook.")
@JsonPropertyOrder(value={"author", "cells", "created", "modified", "name", "status", "time"})
public class NotebookResponseDataAttributes {
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private NotebookAuthor author;
    public static final String JSON_PROPERTY_CELLS = "cells";
    private List<NotebookCellResponse> cells = new ArrayList<NotebookCellResponse>();
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private OffsetDateTime modified;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private NotebookStatus status = NotebookStatus.PUBLISHED;
    public static final String JSON_PROPERTY_TIME = "time";
    private NotebookGlobalTime time;

    public NotebookResponseDataAttributes() {
    }

    @JsonCreator
    public NotebookResponseDataAttributes(@JsonProperty(required=true, value="cells") List<NotebookCellResponse> cells, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="time") NotebookGlobalTime time) {
        this.cells = cells;
        this.name = name;
        this.time = time;
    }

    public NotebookResponseDataAttributes author(NotebookAuthor author) {
        this.author = author;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookAuthor getAuthor() {
        return this.author;
    }

    public void setAuthor(NotebookAuthor author) {
        this.author = author;
    }

    public NotebookResponseDataAttributes cells(List<NotebookCellResponse> cells) {
        this.cells = cells;
        return this;
    }

    public NotebookResponseDataAttributes addCellsItem(NotebookCellResponse cellsItem) {
        this.cells.add(cellsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"attributes\":{\"definition\":{\"text\":\"## Some test markdown\\n\\n```js\\nvar x, y;\\nx = 5;\\ny = 6;\\n```\",\"type\":\"markdown\"}},\"id\":\"bzbycoya\",\"type\":\"notebook_cells\"},{\"attributes\":{\"definition\":{\"requests\":[{\"display_type\":\"line\",\"q\":\"avg:system.load.1{*}\",\"style\":{\"line_type\":\"solid\",\"line_width\":\"normal\",\"palette\":\"dog_classic\"}}],\"show_legend\":true,\"type\":\"timeseries\",\"yaxis\":{\"scale\":\"linear\"}},\"graph_size\":\"m\",\"split_by\":{\"keys\":[],\"tags\":[]},\"time\":null},\"id\":\"9k6bc6xc\",\"type\":\"notebook_cells\"}]", required=true, value="List of cells to display in the notebook.")
    @JsonProperty(value="cells")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<NotebookCellResponse> getCells() {
        return this.cells;
    }

    public void setCells(List<NotebookCellResponse> cells) {
        this.cells = cells;
    }

    @Nullable
    @ApiModelProperty(example="2021-02-24T23:14:15.173964Z", value="UTC time stamp for when the notebook was created.")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(example="2021-02-24T23:15:23.274966Z", value="UTC time stamp for when the notebook was last modified.")
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModified() {
        return this.modified;
    }

    public NotebookResponseDataAttributes name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Example Notebook", required=true, value="The name of the notebook.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NotebookResponseDataAttributes status(NotebookStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookStatus getStatus() {
        return this.status;
    }

    public void setStatus(NotebookStatus status) {
        this.status = status;
    }

    public NotebookResponseDataAttributes time(NotebookGlobalTime time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NotebookGlobalTime getTime() {
        return this.time;
    }

    public void setTime(NotebookGlobalTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookResponseDataAttributes notebookResponseDataAttributes = (NotebookResponseDataAttributes)o;
        return Objects.equals(this.author, notebookResponseDataAttributes.author) && Objects.equals(this.cells, notebookResponseDataAttributes.cells) && Objects.equals(this.created, notebookResponseDataAttributes.created) && Objects.equals(this.modified, notebookResponseDataAttributes.modified) && Objects.equals(this.name, notebookResponseDataAttributes.name) && Objects.equals((Object)this.status, (Object)notebookResponseDataAttributes.status) && Objects.equals(this.time, notebookResponseDataAttributes.time);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.author, this.cells, this.created, this.modified, this.name, this.status, this.time});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebookResponseDataAttributes {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    cells: ").append(this.toIndentedString(this.cells)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

