/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.FormulaAndFunctionMetricAggregation;
import com.datadog.api.v1.client.model.FormulaAndFunctionMetricDataSource;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A formula and functions metrics query.")
@JsonPropertyOrder(value={"aggregator", "data_source", "name", "query"})
public class FormulaAndFunctionMetricQueryDefinition {
    public static final String JSON_PROPERTY_AGGREGATOR = "aggregator";
    private FormulaAndFunctionMetricAggregation aggregator;
    public static final String JSON_PROPERTY_DATA_SOURCE = "data_source";
    private FormulaAndFunctionMetricDataSource dataSource;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;

    public FormulaAndFunctionMetricQueryDefinition() {
    }

    @JsonCreator
    public FormulaAndFunctionMetricQueryDefinition(@JsonProperty(required=true, value="data_source") FormulaAndFunctionMetricDataSource dataSource, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="query") String query) {
        this.dataSource = dataSource;
        this.name = name;
        this.query = query;
    }

    public FormulaAndFunctionMetricQueryDefinition aggregator(FormulaAndFunctionMetricAggregation aggregator) {
        this.aggregator = aggregator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="aggregator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormulaAndFunctionMetricAggregation getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(FormulaAndFunctionMetricAggregation aggregator) {
        this.aggregator = aggregator;
    }

    public FormulaAndFunctionMetricQueryDefinition dataSource(FormulaAndFunctionMetricDataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="data_source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FormulaAndFunctionMetricDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(FormulaAndFunctionMetricDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public FormulaAndFunctionMetricQueryDefinition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="my_query", required=true, value="Name of the query for use in formulas.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FormulaAndFunctionMetricQueryDefinition query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="avg:system.cpu.user{*}", required=true, value="Metrics query definition.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormulaAndFunctionMetricQueryDefinition formulaAndFunctionMetricQueryDefinition = (FormulaAndFunctionMetricQueryDefinition)o;
        return Objects.equals((Object)this.aggregator, (Object)formulaAndFunctionMetricQueryDefinition.aggregator) && Objects.equals((Object)this.dataSource, (Object)formulaAndFunctionMetricQueryDefinition.dataSource) && Objects.equals(this.name, formulaAndFunctionMetricQueryDefinition.name) && Objects.equals(this.query, formulaAndFunctionMetricQueryDefinition.query);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregator, this.dataSource, this.name, this.query});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormulaAndFunctionMetricQueryDefinition {\n");
        sb.append("    aggregator: ").append(this.toIndentedString((Object)this.aggregator)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString((Object)this.dataSource)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

