/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.SecurityMonitoringFilter;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleCase;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleOptions;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleQuery;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Update an existing rule.")
@JsonPropertyOrder(value={"cases", "filters", "isEnabled", "message", "name", "options", "queries", "tags"})
public class SecurityMonitoringRuleUpdatePayload {
    public static final String JSON_PROPERTY_CASES = "cases";
    private List<SecurityMonitoringRuleCase> cases = null;
    public static final String JSON_PROPERTY_FILTERS = "filters";
    private List<SecurityMonitoringFilter> filters = null;
    public static final String JSON_PROPERTY_IS_ENABLED = "isEnabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SecurityMonitoringRuleOptions options;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<SecurityMonitoringRuleQuery> queries = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;

    public SecurityMonitoringRuleUpdatePayload cases(List<SecurityMonitoringRuleCase> cases) {
        this.cases = cases;
        return this;
    }

    public SecurityMonitoringRuleUpdatePayload addCasesItem(SecurityMonitoringRuleCase casesItem) {
        if (this.cases == null) {
            this.cases = new ArrayList<SecurityMonitoringRuleCase>();
        }
        this.cases.add(casesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cases for generating signals.")
    @JsonProperty(value="cases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringRuleCase> getCases() {
        return this.cases;
    }

    public void setCases(List<SecurityMonitoringRuleCase> cases) {
        this.cases = cases;
    }

    public SecurityMonitoringRuleUpdatePayload filters(List<SecurityMonitoringFilter> filters) {
        this.filters = filters;
        return this;
    }

    public SecurityMonitoringRuleUpdatePayload addFiltersItem(SecurityMonitoringFilter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<SecurityMonitoringFilter>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Additional queries to filter matched events before they are processed.")
    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SecurityMonitoringFilter> filters) {
        this.filters = filters;
    }

    public SecurityMonitoringRuleUpdatePayload isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the rule is enabled.")
    @JsonProperty(value="isEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public SecurityMonitoringRuleUpdatePayload message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Message for generated signals.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SecurityMonitoringRuleUpdatePayload name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the rule.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityMonitoringRuleUpdatePayload options(SecurityMonitoringRuleOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleOptions getOptions() {
        return this.options;
    }

    public void setOptions(SecurityMonitoringRuleOptions options) {
        this.options = options;
    }

    public SecurityMonitoringRuleUpdatePayload queries(List<SecurityMonitoringRuleQuery> queries) {
        this.queries = queries;
        return this;
    }

    public SecurityMonitoringRuleUpdatePayload addQueriesItem(SecurityMonitoringRuleQuery queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<SecurityMonitoringRuleQuery>();
        }
        this.queries.add(queriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Queries for selecting logs which are part of the rule.")
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringRuleQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<SecurityMonitoringRuleQuery> queries) {
        this.queries = queries;
    }

    public SecurityMonitoringRuleUpdatePayload tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SecurityMonitoringRuleUpdatePayload addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tags for generated signals.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleUpdatePayload securityMonitoringRuleUpdatePayload = (SecurityMonitoringRuleUpdatePayload)o;
        return Objects.equals(this.cases, securityMonitoringRuleUpdatePayload.cases) && Objects.equals(this.filters, securityMonitoringRuleUpdatePayload.filters) && Objects.equals(this.isEnabled, securityMonitoringRuleUpdatePayload.isEnabled) && Objects.equals(this.message, securityMonitoringRuleUpdatePayload.message) && Objects.equals(this.name, securityMonitoringRuleUpdatePayload.name) && Objects.equals(this.options, securityMonitoringRuleUpdatePayload.options) && Objects.equals(this.queries, securityMonitoringRuleUpdatePayload.queries) && Objects.equals(this.tags, securityMonitoringRuleUpdatePayload.tags);
    }

    public int hashCode() {
        return Objects.hash(this.cases, this.filters, this.isEnabled, this.message, this.name, this.options, this.queries, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleUpdatePayload {\n");
        sb.append("    cases: ").append(this.toIndentedString(this.cases)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

