/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The attributes associated with the archive order.")
@JsonPropertyOrder(value={"archive_ids"})
public class LogsArchiveOrderAttributes {
    public static final String JSON_PROPERTY_ARCHIVE_IDS = "archive_ids";
    private List<String> archiveIds = new ArrayList<String>();

    public LogsArchiveOrderAttributes archiveIds(List<String> archiveIds) {
        this.archiveIds = archiveIds;
        return this;
    }

    public LogsArchiveOrderAttributes addArchiveIdsItem(String archiveIdsItem) {
        this.archiveIds.add(archiveIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"a2zcMylnM4OCHpYusxIi1g\",\"a2zcMylnM4OCHpYusxIi2g\",\"a2zcMylnM4OCHpYusxIi3g\"]", required=true, value="An ordered array of `<ARCHIVE_ID>` strings, the order of archive IDs in the array define the overall archives order for Datadog.")
    @JsonProperty(value="archive_ids")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getArchiveIds() {
        return this.archiveIds;
    }

    public void setArchiveIds(List<String> archiveIds) {
        this.archiveIds = archiveIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsArchiveOrderAttributes logsArchiveOrderAttributes = (LogsArchiveOrderAttributes)o;
        return Objects.equals(this.archiveIds, logsArchiveOrderAttributes.archiveIds);
    }

    public int hashCode() {
        return Objects.hash(this.archiveIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsArchiveOrderAttributes {\n");
        sb.append("    archiveIds: ").append(this.toIndentedString(this.archiveIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

