/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.WidgetFormulaLimit;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Formula to be used in a widget query.")
@JsonPropertyOrder(value={"alias", "formula", "limit"})
public class WidgetFormula {
    public static final String JSON_PROPERTY_ALIAS = "alias";
    private String alias;
    public static final String JSON_PROPERTY_FORMULA = "formula";
    private String formula;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private WidgetFormulaLimit limit;

    public WidgetFormula alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Expression alias.")
    @JsonProperty(value="alias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public WidgetFormula formula(String formula) {
        this.formula = formula;
        return this;
    }

    @ApiModelProperty(example="func(a) + b", required=true, value="String expression built from queries, formulas, and functions.")
    @JsonProperty(value="formula")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public WidgetFormula limit(WidgetFormulaLimit limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetFormulaLimit getLimit() {
        return this.limit;
    }

    public void setLimit(WidgetFormulaLimit limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetFormula widgetFormula = (WidgetFormula)o;
        return Objects.equals(this.alias, widgetFormula.alias) && Objects.equals(this.formula, widgetFormula.formula) && Objects.equals(this.limit, widgetFormula.limit);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.formula, this.limit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WidgetFormula {\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    formula: ").append(this.toIndentedString(this.formula)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

