/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Compliance Monitoring usage for a given organization for a given hour.")
@JsonPropertyOrder(value={"compliance_container_count", "compliance_host_count", "hour"})
public class UsageComplianceHour {
    public static final String JSON_PROPERTY_COMPLIANCE_CONTAINER_COUNT = "compliance_container_count";
    private Long complianceContainerCount;
    public static final String JSON_PROPERTY_COMPLIANCE_HOST_COUNT = "compliance_host_count";
    private Long complianceHostCount;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;

    public UsageComplianceHour complianceContainerCount(Long complianceContainerCount) {
        this.complianceContainerCount = complianceContainerCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of compliance container hours from the start of the given hour's month until the given hour.")
    @JsonProperty(value="compliance_container_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getComplianceContainerCount() {
        return this.complianceContainerCount;
    }

    public void setComplianceContainerCount(Long complianceContainerCount) {
        this.complianceContainerCount = complianceContainerCount;
    }

    public UsageComplianceHour complianceHostCount(Long complianceHostCount) {
        this.complianceHostCount = complianceHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of compliance hosts hours from the start of the given hour's month until the given hour.")
    @JsonProperty(value="compliance_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getComplianceHostCount() {
        return this.complianceHostCount;
    }

    public void setComplianceHostCount(Long complianceHostCount) {
        this.complianceHostCount = complianceHostCount;
    }

    public UsageComplianceHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageComplianceHour usageComplianceHour = (UsageComplianceHour)o;
        return Objects.equals(this.complianceContainerCount, usageComplianceHour.complianceContainerCount) && Objects.equals(this.complianceHostCount, usageComplianceHour.complianceHostCount) && Objects.equals(this.hour, usageComplianceHour.hour);
    }

    public int hashCode() {
        return Objects.hash(this.complianceContainerCount, this.complianceHostCount, this.hour);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageComplianceHour {\n");
        sb.append("    complianceContainerCount: ").append(this.toIndentedString(this.complianceContainerCount)).append("\n");
        sb.append("    complianceHostCount: ").append(this.toIndentedString(this.complianceHostCount)).append("\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

