/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.TableWidgetDefinitionType;
import com.datadog.api.v1.client.model.TableWidgetHasSearchBar;
import com.datadog.api.v1.client.model.TableWidgetRequest;
import com.datadog.api.v1.client.model.WidgetCustomLink;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The table visualization is available on timeboards and screenboards. It displays columns of metrics grouped by tag key.")
@JsonPropertyOrder(value={"custom_links", "has_search_bar", "requests", "time", "title", "title_align", "title_size", "type"})
public class TableWidgetDefinition {
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_HAS_SEARCH_BAR = "has_search_bar";
    private TableWidgetHasSearchBar hasSearchBar;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<TableWidgetRequest> requests = new ArrayList<TableWidgetRequest>();
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TableWidgetDefinitionType type = TableWidgetDefinitionType.QUERY_TABLE;

    public TableWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        return this;
    }

    public TableWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of custom links.")
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public TableWidgetDefinition hasSearchBar(TableWidgetHasSearchBar hasSearchBar) {
        this.hasSearchBar = hasSearchBar;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="has_search_bar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableWidgetHasSearchBar getHasSearchBar() {
        return this.hasSearchBar;
    }

    public void setHasSearchBar(TableWidgetHasSearchBar hasSearchBar) {
        this.hasSearchBar = hasSearchBar;
    }

    public TableWidgetDefinition requests(List<TableWidgetRequest> requests) {
        this.requests = requests;
        return this;
    }

    public TableWidgetDefinition addRequestsItem(TableWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"q/apm_query/log_query\":\"<METRIC_1>{<SCOPE_1>}\"}]", required=true, value="Widget definition.")
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TableWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<TableWidgetRequest> requests) {
        this.requests = requests;
    }

    public TableWidgetDefinition time(WidgetTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public TableWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of your widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TableWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public TableWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public TableWidgetDefinition type(TableWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TableWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(TableWidgetDefinitionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableWidgetDefinition tableWidgetDefinition = (TableWidgetDefinition)o;
        return Objects.equals(this.customLinks, tableWidgetDefinition.customLinks) && Objects.equals((Object)this.hasSearchBar, (Object)tableWidgetDefinition.hasSearchBar) && Objects.equals(this.requests, tableWidgetDefinition.requests) && Objects.equals(this.time, tableWidgetDefinition.time) && Objects.equals(this.title, tableWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)tableWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, tableWidgetDefinition.titleSize) && Objects.equals((Object)this.type, (Object)tableWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customLinks, this.hasSearchBar, this.requests, this.time, this.title, this.titleAlign, this.titleSize, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableWidgetDefinition {\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    hasSearchBar: ").append(this.toIndentedString((Object)this.hasSearchBar)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

