/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.MetricsQueryUnit;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing all metric names returned and their associated metadata.")
@JsonPropertyOrder(value={"aggr", "display_name", "end", "expression", "interval", "length", "metric", "pointlist", "scope", "start", "unit"})
public class MetricsQueryMetadata {
    public static final String JSON_PROPERTY_AGGR = "aggr";
    private String aggr;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "display_name";
    private String displayName;
    public static final String JSON_PROPERTY_END = "end";
    private Long end;
    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private Long interval;
    public static final String JSON_PROPERTY_LENGTH = "length";
    private Long length;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_POINTLIST = "pointlist";
    private List<List<Double>> pointlist = null;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;
    public static final String JSON_PROPERTY_START = "start";
    private Long start;
    public static final String JSON_PROPERTY_UNIT = "unit";
    private List<MetricsQueryUnit> unit = null;

    @Nullable
    @ApiModelProperty(example="avg", value="Aggregation type.")
    @JsonProperty(value="aggr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAggr() {
        return this.aggr;
    }

    @Nullable
    @ApiModelProperty(example="system.cpu.idle", value="Display name of the metric.")
    @JsonProperty(value="display_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    @ApiModelProperty(value="End of the time window, milliseconds since Unix epoch.")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEnd() {
        return this.end;
    }

    @Nullable
    @ApiModelProperty(example="system.cpu.idle{host:foo,env:test}", value="Metric expression.")
    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpression() {
        return this.expression;
    }

    @Nullable
    @ApiModelProperty(value="Number of seconds between data samples.")
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getInterval() {
        return this.interval;
    }

    @Nullable
    @ApiModelProperty(value="Number of data samples.")
    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLength() {
        return this.length;
    }

    @Nullable
    @ApiModelProperty(example="system.cpu.idle", value="Metric name.")
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    @Nullable
    @ApiModelProperty(value="List of points of the time series.")
    @JsonProperty(value="pointlist")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<List<Double>> getPointlist() {
        return this.pointlist;
    }

    @Nullable
    @ApiModelProperty(example="host:foo,env:test", value="Metric scope, comma separated list of tags.")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScope() {
        return this.scope;
    }

    @Nullable
    @ApiModelProperty(value="Start of the time window, milliseconds since Unix epoch.")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStart() {
        return this.start;
    }

    @Nullable
    @ApiModelProperty(value="Detailed information about the metric unit. First element describes the \"primary unit\" (for example, `bytes` in `bytes per second`), second describes the \"per unit\" (for example, `second` in `bytes per second`).")
    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MetricsQueryUnit> getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsQueryMetadata metricsQueryMetadata = (MetricsQueryMetadata)o;
        return Objects.equals(this.aggr, metricsQueryMetadata.aggr) && Objects.equals(this.displayName, metricsQueryMetadata.displayName) && Objects.equals(this.end, metricsQueryMetadata.end) && Objects.equals(this.expression, metricsQueryMetadata.expression) && Objects.equals(this.interval, metricsQueryMetadata.interval) && Objects.equals(this.length, metricsQueryMetadata.length) && Objects.equals(this.metric, metricsQueryMetadata.metric) && Objects.equals(this.pointlist, metricsQueryMetadata.pointlist) && Objects.equals(this.scope, metricsQueryMetadata.scope) && Objects.equals(this.start, metricsQueryMetadata.start) && Objects.equals(this.unit, metricsQueryMetadata.unit);
    }

    public int hashCode() {
        return Objects.hash(this.aggr, this.displayName, this.end, this.expression, this.interval, this.length, this.metric, this.pointlist, this.scope, this.start, this.unit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricsQueryMetadata {\n");
        sb.append("    aggr: ").append(this.toIndentedString(this.aggr)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    pointlist: ").append(this.toIndentedString(this.pointlist)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

