/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsLookupProcessorType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Use the Lookup Processor to define a mapping between a log attribute and a human readable value saved in the processors mapping table. For example, you can use the Lookup Processor to map an internal service ID into a human readable service name. Alternatively, you could also use it to check if the MAC address that just attempted to connect to the production environment belongs to your list of stolen machines.")
@JsonPropertyOrder(value={"default_lookup", "is_enabled", "lookup_table", "name", "source", "target", "type"})
public class LogsLookupProcessor {
    public static final String JSON_PROPERTY_DEFAULT_LOOKUP = "default_lookup";
    private String defaultLookup;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_LOOKUP_TABLE = "lookup_table";
    private List<String> lookupTable = new ArrayList<String>();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private String source;
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsLookupProcessorType type = LogsLookupProcessorType.LOOKUP_PROCESSOR;

    public LogsLookupProcessor defaultLookup(String defaultLookup) {
        this.defaultLookup = defaultLookup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Value to set the target attribute if the source value is not found in the list.")
    @JsonProperty(value="default_lookup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultLookup() {
        return this.defaultLookup;
    }

    public void setDefaultLookup(String defaultLookup) {
        this.defaultLookup = defaultLookup;
    }

    public LogsLookupProcessor isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the processor is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsLookupProcessor lookupTable(List<String> lookupTable) {
        this.lookupTable = lookupTable;
        return this;
    }

    public LogsLookupProcessor addLookupTableItem(String lookupTableItem) {
        this.lookupTable.add(lookupTableItem);
        return this;
    }

    @ApiModelProperty(example="[]", required=true, value="Mapping table of values for the source attribute and their associated target attribute values, formatted as `[\"source_key1,target_value1\", \"source_key2,target_value2\"]`")
    @JsonProperty(value="lookup_table")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getLookupTable() {
        return this.lookupTable;
    }

    public void setLookupTable(List<String> lookupTable) {
        this.lookupTable = lookupTable;
    }

    public LogsLookupProcessor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the processor.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsLookupProcessor source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Source attribute used to perform the lookup.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public LogsLookupProcessor target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Name of the attribute that contains the corresponding value in the mapping list or the `default_lookup` if not found in the mapping list.")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsLookupProcessor type(LogsLookupProcessorType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsLookupProcessorType getType() {
        return this.type;
    }

    public void setType(LogsLookupProcessorType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsLookupProcessor logsLookupProcessor = (LogsLookupProcessor)o;
        return Objects.equals(this.defaultLookup, logsLookupProcessor.defaultLookup) && Objects.equals(this.isEnabled, logsLookupProcessor.isEnabled) && Objects.equals(this.lookupTable, logsLookupProcessor.lookupTable) && Objects.equals(this.name, logsLookupProcessor.name) && Objects.equals(this.source, logsLookupProcessor.source) && Objects.equals(this.target, logsLookupProcessor.target) && Objects.equals((Object)this.type, (Object)logsLookupProcessor.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultLookup, this.isEnabled, this.lookupTable, this.name, this.source, this.target, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsLookupProcessor {\n");
        sb.append("    defaultLookup: ").append(this.toIndentedString(this.defaultLookup)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    lookupTable: ").append(this.toIndentedString(this.lookupTable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

