/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Tracing without limits usage for a given organization for a given hour.")
@JsonPropertyOrder(value={"hour", "ingested_events_bytes"})
public class UsageTracingWithoutLimitsHour {
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_INGESTED_EVENTS_BYTES = "ingested_events_bytes";
    private Long ingestedEventsBytes;

    public UsageTracingWithoutLimitsHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageTracingWithoutLimitsHour ingestedEventsBytes(Long ingestedEventsBytes) {
        this.ingestedEventsBytes = ingestedEventsBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the total number of bytes ingested during a given hour.")
    @JsonProperty(value="ingested_events_bytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIngestedEventsBytes() {
        return this.ingestedEventsBytes;
    }

    public void setIngestedEventsBytes(Long ingestedEventsBytes) {
        this.ingestedEventsBytes = ingestedEventsBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageTracingWithoutLimitsHour usageTracingWithoutLimitsHour = (UsageTracingWithoutLimitsHour)o;
        return Objects.equals(this.hour, usageTracingWithoutLimitsHour.hour) && Objects.equals(this.ingestedEventsBytes, usageTracingWithoutLimitsHour.ingestedEventsBytes);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.ingestedEventsBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageTracingWithoutLimitsHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    ingestedEventsBytes: ").append(this.toIndentedString(this.ingestedEventsBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

