/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsDeviceID;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing the device used to perform the Synthetic test.")
@JsonPropertyOrder(value={"height", "id", "isMobile", "name", "width"})
public class SyntheticsDevice {
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Long height;
    public static final String JSON_PROPERTY_ID = "id";
    private SyntheticsDeviceID id;
    public static final String JSON_PROPERTY_IS_MOBILE = "isMobile";
    private Boolean isMobile;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Long width;

    public SyntheticsDevice height(Long height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Screen height of the device.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getHeight() {
        return this.height;
    }

    public void setHeight(Long height) {
        this.height = height;
    }

    public SyntheticsDevice id(SyntheticsDeviceID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsDeviceID getId() {
        return this.id;
    }

    public void setId(SyntheticsDeviceID id) {
        this.id = id;
    }

    public SyntheticsDevice isMobile(Boolean isMobile) {
        this.isMobile = isMobile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the device is a mobile.")
    @JsonProperty(value="isMobile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsMobile() {
        return this.isMobile;
    }

    public void setIsMobile(Boolean isMobile) {
        this.isMobile = isMobile;
    }

    public SyntheticsDevice name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="The device name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsDevice width(Long width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Screen width of the device.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getWidth() {
        return this.width;
    }

    public void setWidth(Long width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsDevice syntheticsDevice = (SyntheticsDevice)o;
        return Objects.equals(this.height, syntheticsDevice.height) && Objects.equals((Object)this.id, (Object)syntheticsDevice.id) && Objects.equals(this.isMobile, syntheticsDevice.isMobile) && Objects.equals(this.name, syntheticsDevice.name) && Objects.equals(this.width, syntheticsDevice.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.height, this.id, this.isMobile, this.name, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsDevice {\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    isMobile: ").append(this.toIndentedString(this.isMobile)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

