/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A metric SLI query. **Required if type is `metric`**. Note that Datadog only allows the sum by aggregator to be used because this will sum up all request counts instead of averaging them, or taking the max or min of all of those requests.")
@JsonPropertyOrder(value={"denominator", "numerator"})
public class ServiceLevelObjectiveQuery {
    public static final String JSON_PROPERTY_DENOMINATOR = "denominator";
    private String denominator;
    public static final String JSON_PROPERTY_NUMERATOR = "numerator";
    private String numerator;

    public ServiceLevelObjectiveQuery denominator(String denominator) {
        this.denominator = denominator;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="A Datadog metric query for total (valid) events.")
    @JsonProperty(value="denominator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDenominator() {
        return this.denominator;
    }

    public void setDenominator(String denominator) {
        this.denominator = denominator;
    }

    public ServiceLevelObjectiveQuery numerator(String numerator) {
        this.numerator = numerator;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="A Datadog metric query for good events.")
    @JsonProperty(value="numerator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNumerator() {
        return this.numerator;
    }

    public void setNumerator(String numerator) {
        this.numerator = numerator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelObjectiveQuery serviceLevelObjectiveQuery = (ServiceLevelObjectiveQuery)o;
        return Objects.equals(this.denominator, serviceLevelObjectiveQuery.denominator) && Objects.equals(this.numerator, serviceLevelObjectiveQuery.numerator);
    }

    public int hashCode() {
        return Objects.hash(this.denominator, this.numerator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelObjectiveQuery {\n");
        sb.append("    denominator: ").append(this.toIndentedString(this.denominator)).append("\n");
        sb.append("    numerator: ").append(this.toIndentedString(this.numerator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

