/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsListRequestTime;
import com.datadog.api.v1.client.model.LogsSort;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object to send with the request to retrieve a list of logs from your Organization.")
@JsonPropertyOrder(value={"index", "limit", "query", "sort", "startAt", "time"})
public class LogsListRequest {
    public static final String JSON_PROPERTY_INDEX = "index";
    private String index;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Integer limit;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_SORT = "sort";
    private LogsSort sort;
    public static final String JSON_PROPERTY_START_AT = "startAt";
    private String startAt;
    public static final String JSON_PROPERTY_TIME = "time";
    private LogsListRequestTime time;

    public LogsListRequest index(String index) {
        this.index = index;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="retention-3,retention-15", value="The log index on which the request is performed. For multi-index organizations, the default is all live indexes. Historical indexes of rehydrated logs must be specified.")
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public LogsListRequest limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of logs return in the response.")
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public LogsListRequest query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="service:web* AND @http.status_code:[200 TO 299]", value="The search query - following the log search syntax.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public LogsListRequest sort(LogsSort sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsSort getSort() {
        return this.sort;
    }

    public void setSort(LogsSort sort) {
        this.sort = sort;
    }

    public LogsListRequest startAt(String startAt) {
        this.startAt = startAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hash identifier of the first log to return in the list, available in a log `id` attribute. This parameter is used for the pagination feature.  **Note**: This parameter is ignored if the corresponding log is out of the scope of the specified time window.")
    @JsonProperty(value="startAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartAt() {
        return this.startAt;
    }

    public void setStartAt(String startAt) {
        this.startAt = startAt;
    }

    public LogsListRequest time(LogsListRequestTime time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsListRequestTime getTime() {
        return this.time;
    }

    public void setTime(LogsListRequestTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsListRequest logsListRequest = (LogsListRequest)o;
        return Objects.equals(this.index, logsListRequest.index) && Objects.equals(this.limit, logsListRequest.limit) && Objects.equals(this.query, logsListRequest.query) && Objects.equals((Object)this.sort, (Object)logsListRequest.sort) && Objects.equals(this.startAt, logsListRequest.startAt) && Objects.equals(this.time, logsListRequest.time);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.limit, this.query, this.sort, this.startAt, this.time});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsListRequest {\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString((Object)this.sort)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

