/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="An object defining the recurrence of the downtime.")
@JsonPropertyOrder(value={"period", "rrule", "type", "until_date", "until_occurrences", "week_days"})
public class DowntimeRecurrence {
    public static final String JSON_PROPERTY_PERIOD = "period";
    private Integer period;
    public static final String JSON_PROPERTY_RRULE = "rrule";
    private String rrule;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_UNTIL_DATE = "until_date";
    private JsonNullable<Long> untilDate = JsonNullable.undefined();
    public static final String JSON_PROPERTY_UNTIL_OCCURRENCES = "until_occurrences";
    private JsonNullable<Integer> untilOccurrences = JsonNullable.undefined();
    public static final String JSON_PROPERTY_WEEK_DAYS = "week_days";
    private List<String> weekDays = null;

    public DowntimeRecurrence period(Integer period) {
        this.period = period;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="How often to repeat as an integer. For example, to repeat every 3 days, select a type of `days` and a period of `3`.")
    @JsonProperty(value="period")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public DowntimeRecurrence rrule(String rrule) {
        this.rrule = rrule;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="FREQ=MONTHLY;BYSETPOS=3;BYDAY=WE;INTERVAL=1", value="The `RRULE` standard for defining recurring events. For example, to have a recurring event on the first day of each month, select a type of `rrule` and set the `FREQ` to `MONTHLY` and `BYMONTHDAY` to `1`. Most common `rrule` options from the [iCalendar Spec](https://tools.ietf.org/html/rfc5545) are supported.  **Note**: Attributes specifying the duration in `RRULE` are not supported (for example, `DTSTART`, `DTEND`, `DURATION`).")
    @JsonProperty(value="rrule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRrule() {
        return this.rrule;
    }

    public void setRrule(String rrule) {
        this.rrule = rrule;
    }

    public DowntimeRecurrence type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="weeks", value="The type of recurrence. Choose from `days`, `weeks`, `months`, `years`.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DowntimeRecurrence untilDate(Long untilDate) {
        this.untilDate = JsonNullable.of((Object)untilDate);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1447786293", value="The date at which the recurrence should end as a POSIX timestamp. `until_occurences` and `until_date` are mutually exclusive.")
    @JsonIgnore
    public Long getUntilDate() {
        return (Long)this.untilDate.orElse(null);
    }

    @JsonProperty(value="until_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getUntilDate_JsonNullable() {
        return this.untilDate;
    }

    @JsonProperty(value="until_date")
    public void setUntilDate_JsonNullable(JsonNullable<Long> untilDate) {
        this.untilDate = untilDate;
    }

    public void setUntilDate(Long untilDate) {
        this.untilDate = JsonNullable.of((Object)untilDate);
    }

    public DowntimeRecurrence untilOccurrences(Integer untilOccurrences) {
        this.untilOccurrences = JsonNullable.of((Object)untilOccurrences);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="How many times the downtime is rescheduled. `until_occurences` and `until_date` are mutually exclusive.")
    @JsonIgnore
    public Integer getUntilOccurrences() {
        return (Integer)this.untilOccurrences.orElse(null);
    }

    @JsonProperty(value="until_occurrences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getUntilOccurrences_JsonNullable() {
        return this.untilOccurrences;
    }

    @JsonProperty(value="until_occurrences")
    public void setUntilOccurrences_JsonNullable(JsonNullable<Integer> untilOccurrences) {
        this.untilOccurrences = untilOccurrences;
    }

    public void setUntilOccurrences(Integer untilOccurrences) {
        this.untilOccurrences = JsonNullable.of((Object)untilOccurrences);
    }

    public DowntimeRecurrence weekDays(List<String> weekDays) {
        this.weekDays = weekDays;
        return this;
    }

    public DowntimeRecurrence addWeekDaysItem(String weekDaysItem) {
        if (this.weekDays == null) {
            this.weekDays = new ArrayList<String>();
        }
        this.weekDays.add(weekDaysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"Mon\",\"Tue\"]", value="A list of week days to repeat on. Choose from `Mon`, `Tue`, `Wed`, `Thu`, `Fri`, `Sat` or `Sun`. Only applicable when type is weeks. First letter must be capitalized.")
    @JsonProperty(value="week_days")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getWeekDays() {
        return this.weekDays;
    }

    public void setWeekDays(List<String> weekDays) {
        this.weekDays = weekDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DowntimeRecurrence downtimeRecurrence = (DowntimeRecurrence)o;
        return Objects.equals(this.period, downtimeRecurrence.period) && Objects.equals(this.rrule, downtimeRecurrence.rrule) && Objects.equals(this.type, downtimeRecurrence.type) && Objects.equals(this.untilDate, downtimeRecurrence.untilDate) && Objects.equals(this.untilOccurrences, downtimeRecurrence.untilOccurrences) && Objects.equals(this.weekDays, downtimeRecurrence.weekDays);
    }

    public int hashCode() {
        return Objects.hash(this.period, this.rrule, this.type, this.untilDate, this.untilOccurrences, this.weekDays);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DowntimeRecurrence {\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    rrule: ").append(this.toIndentedString(this.rrule)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    untilDate: ").append(this.toIndentedString(this.untilDate)).append("\n");
        sb.append("    untilOccurrences: ").append(this.toIndentedString(this.untilOccurrences)).append("\n");
        sb.append("    weekDays: ").append(this.toIndentedString(this.weekDays)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

