/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.User;
import com.datadog.api.v1.client.model.UserDisableResponse;
import com.datadog.api.v1.client.model.UserListResponse;
import com.datadog.api.v1.client.model.UserResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<UserResponse> createUserWithHttpInfo(User body) throws ApiException {
        User localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createUser");
        }
        String localVarPath = "/api/v1/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createUser");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UserResponse> localVarReturnType = new GenericType<UserResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.createUser", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateUserRequest createUser() throws ApiException {
        return new APIcreateUserRequest();
    }

    private ApiResponse<UserDisableResponse> disableUserWithHttpInfo(String userHandle) throws ApiException {
        Object localVarPostBody = null;
        if (userHandle == null) {
            throw new ApiException(400, "Missing the required parameter 'userHandle' when calling disableUser");
        }
        String localVarPath = "/api/v1/user/{user_handle}".replaceAll("\\{user_handle\\}", this.apiClient.escapeString(userHandle.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "disableUser");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UserDisableResponse> localVarReturnType = new GenericType<UserDisableResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.disableUser", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIdisableUserRequest disableUser(String userHandle) throws ApiException {
        return new APIdisableUserRequest(userHandle);
    }

    private ApiResponse<UserResponse> getUserWithHttpInfo(String userHandle) throws ApiException {
        Object localVarPostBody = null;
        if (userHandle == null) {
            throw new ApiException(400, "Missing the required parameter 'userHandle' when calling getUser");
        }
        String localVarPath = "/api/v1/user/{user_handle}".replaceAll("\\{user_handle\\}", this.apiClient.escapeString(userHandle.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getUser");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UserResponse> localVarReturnType = new GenericType<UserResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.getUser", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUserRequest getUser(String userHandle) throws ApiException {
        return new APIgetUserRequest(userHandle);
    }

    private ApiResponse<UserListResponse> listUsersWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listUsers");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UserListResponse> localVarReturnType = new GenericType<UserListResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.listUsers", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistUsersRequest listUsers() throws ApiException {
        return new APIlistUsersRequest();
    }

    private ApiResponse<UserResponse> updateUserWithHttpInfo(String userHandle, User body) throws ApiException {
        User localVarPostBody = body;
        if (userHandle == null) {
            throw new ApiException(400, "Missing the required parameter 'userHandle' when calling updateUser");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateUser");
        }
        String localVarPath = "/api/v1/user/{user_handle}".replaceAll("\\{user_handle\\}", this.apiClient.escapeString(userHandle.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateUser");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UserResponse> localVarReturnType = new GenericType<UserResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.updateUser", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateUserRequest updateUser(String userHandle) throws ApiException {
        return new APIupdateUserRequest(userHandle);
    }

    public class APIupdateUserRequest {
        private String userHandle;
        private User body;

        private APIupdateUserRequest(String userHandle) {
            this.userHandle = userHandle;
        }

        public APIupdateUserRequest body(User body) {
            this.body = body;
            return this;
        }

        public UserResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UserResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.updateUserWithHttpInfo(this.userHandle, this.body);
        }
    }

    public class APIlistUsersRequest {
        private APIlistUsersRequest() {
        }

        public UserListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UserListResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.listUsersWithHttpInfo();
        }
    }

    public class APIgetUserRequest {
        private String userHandle;

        private APIgetUserRequest(String userHandle) {
            this.userHandle = userHandle;
        }

        public UserResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UserResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.getUserWithHttpInfo(this.userHandle);
        }
    }

    public class APIdisableUserRequest {
        private String userHandle;

        private APIdisableUserRequest(String userHandle) {
            this.userHandle = userHandle;
        }

        public UserDisableResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UserDisableResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.disableUserWithHttpInfo(this.userHandle);
        }
    }

    public class APIcreateUserRequest {
        private User body;

        private APIcreateUserRequest() {
        }

        public APIcreateUserRequest body(User body) {
            this.body = body;
            return this;
        }

        public UserResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UserResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.createUserWithHttpInfo(this.body);
        }
    }
}

