/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.EventListResponse;
import com.datadog.api.v1.client.model.EventPriority;
import com.datadog.api.v1.client.model.EventResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class EventsApi {
    private ApiClient apiClient;

    public EventsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EventsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<EventResponse> getEventWithHttpInfo(Long eventId) throws ApiException {
        Object localVarPostBody = null;
        if (eventId == null) {
            throw new ApiException(400, "Missing the required parameter 'eventId' when calling getEvent");
        }
        String localVarPath = "/api/v1/events/{event_id}".replaceAll("\\{event_id\\}", this.apiClient.escapeString(eventId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getEvent");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<EventResponse> localVarReturnType = new GenericType<EventResponse>(){};
        return this.apiClient.invokeAPI("EventsApi.getEvent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetEventRequest getEvent(Long eventId) throws ApiException {
        return new APIgetEventRequest(eventId);
    }

    private ApiResponse<EventListResponse> listEventsWithHttpInfo(Long start, Long end, EventPriority priority, String sources, String tags, Boolean unaggregated) throws ApiException {
        Object localVarPostBody = null;
        if (start == null) {
            throw new ApiException(400, "Missing the required parameter 'start' when calling listEvents");
        }
        if (end == null) {
            throw new ApiException(400, "Missing the required parameter 'end' when calling listEvents");
        }
        String localVarPath = "/api/v1/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end", end));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "priority", (Object)priority));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sources", sources));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "unaggregated", unaggregated));
        localVarHeaderParams.put("DD-OPERATION-ID", "listEvents");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<EventListResponse> localVarReturnType = new GenericType<EventListResponse>(){};
        return this.apiClient.invokeAPI("EventsApi.listEvents", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistEventsRequest listEvents() throws ApiException {
        return new APIlistEventsRequest();
    }

    public class APIlistEventsRequest {
        private Long start;
        private Long end;
        private EventPriority priority;
        private String sources;
        private String tags;
        private Boolean unaggregated;

        private APIlistEventsRequest() {
        }

        public APIlistEventsRequest start(Long start) {
            this.start = start;
            return this;
        }

        public APIlistEventsRequest end(Long end) {
            this.end = end;
            return this;
        }

        public APIlistEventsRequest priority(EventPriority priority) {
            this.priority = priority;
            return this;
        }

        public APIlistEventsRequest sources(String sources) {
            this.sources = sources;
            return this;
        }

        public APIlistEventsRequest tags(String tags) {
            this.tags = tags;
            return this;
        }

        public APIlistEventsRequest unaggregated(Boolean unaggregated) {
            this.unaggregated = unaggregated;
            return this;
        }

        public EventListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<EventListResponse> executeWithHttpInfo() throws ApiException {
            return EventsApi.this.listEventsWithHttpInfo(this.start, this.end, this.priority, this.sources, this.tags, this.unaggregated);
        }
    }

    public class APIgetEventRequest {
        private Long eventId;

        private APIgetEventRequest(Long eventId) {
            this.eventId = eventId;
        }

        public EventResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<EventResponse> executeWithHttpInfo() throws ApiException {
            return EventsApi.this.getEventWithHttpInfo(this.eventId);
        }
    }
}

