/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.DashboardList;
import com.datadog.api.v1.client.model.DashboardListDeleteResponse;
import com.datadog.api.v1.client.model.DashboardListListResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class DashboardListsApi {
    private ApiClient apiClient;

    public DashboardListsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DashboardListsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<DashboardList> createDashboardListWithHttpInfo(DashboardList body) throws ApiException {
        DashboardList localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createDashboardList");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardList> localVarReturnType = new GenericType<DashboardList>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.createDashboardList", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateDashboardListRequest createDashboardList() throws ApiException {
        return new APIcreateDashboardListRequest();
    }

    private ApiResponse<DashboardListDeleteResponse> deleteDashboardListWithHttpInfo(Long listId) throws ApiException {
        Object localVarPostBody = null;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling deleteDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteDashboardList");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListDeleteResponse> localVarReturnType = new GenericType<DashboardListDeleteResponse>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.deleteDashboardList", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIdeleteDashboardListRequest deleteDashboardList(Long listId) throws ApiException {
        return new APIdeleteDashboardListRequest(listId);
    }

    private ApiResponse<DashboardList> getDashboardListWithHttpInfo(Long listId) throws ApiException {
        Object localVarPostBody = null;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling getDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getDashboardList");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardList> localVarReturnType = new GenericType<DashboardList>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.getDashboardList", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetDashboardListRequest getDashboardList(Long listId) throws ApiException {
        return new APIgetDashboardListRequest(listId);
    }

    private ApiResponse<DashboardListListResponse> listDashboardListsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/dashboard/lists/manual";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listDashboardLists");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListListResponse> localVarReturnType = new GenericType<DashboardListListResponse>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.listDashboardLists", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistDashboardListsRequest listDashboardLists() throws ApiException {
        return new APIlistDashboardListsRequest();
    }

    private ApiResponse<DashboardList> updateDashboardListWithHttpInfo(Long listId, DashboardList body) throws ApiException {
        DashboardList localVarPostBody = body;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling updateDashboardList");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateDashboardList");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardList> localVarReturnType = new GenericType<DashboardList>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.updateDashboardList", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateDashboardListRequest updateDashboardList(Long listId) throws ApiException {
        return new APIupdateDashboardListRequest(listId);
    }

    public class APIupdateDashboardListRequest {
        private Long listId;
        private DashboardList body;

        private APIupdateDashboardListRequest(Long listId) {
            this.listId = listId;
        }

        public APIupdateDashboardListRequest body(DashboardList body) {
            this.body = body;
            return this;
        }

        public DashboardList execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<DashboardList> executeWithHttpInfo() throws ApiException {
            return DashboardListsApi.this.updateDashboardListWithHttpInfo(this.listId, this.body);
        }
    }

    public class APIlistDashboardListsRequest {
        private APIlistDashboardListsRequest() {
        }

        public DashboardListListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<DashboardListListResponse> executeWithHttpInfo() throws ApiException {
            return DashboardListsApi.this.listDashboardListsWithHttpInfo();
        }
    }

    public class APIgetDashboardListRequest {
        private Long listId;

        private APIgetDashboardListRequest(Long listId) {
            this.listId = listId;
        }

        public DashboardList execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<DashboardList> executeWithHttpInfo() throws ApiException {
            return DashboardListsApi.this.getDashboardListWithHttpInfo(this.listId);
        }
    }

    public class APIdeleteDashboardListRequest {
        private Long listId;

        private APIdeleteDashboardListRequest(Long listId) {
            this.listId = listId;
        }

        public DashboardListDeleteResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<DashboardListDeleteResponse> executeWithHttpInfo() throws ApiException {
            return DashboardListsApi.this.deleteDashboardListWithHttpInfo(this.listId);
        }
    }

    public class APIcreateDashboardListRequest {
        private DashboardList body;

        private APIcreateDashboardListRequest() {
        }

        public APIcreateDashboardListRequest body(DashboardList body) {
            this.body = body;
            return this;
        }

        public DashboardList execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<DashboardList> executeWithHttpInfo() throws ApiException {
            return DashboardListsApi.this.createDashboardListWithHttpInfo(this.body);
        }
    }
}

