/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.SecurityMonitoringRuleCase;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleOptions;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleQuery;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Create a new rule.")
@JsonPropertyOrder(value={"cases", "enabled", "message", "name", "options", "queries", "tags"})
public class SecurityMonitoringRuleCreatePayload {
    public static final String JSON_PROPERTY_CASES = "cases";
    private List<SecurityMonitoringRuleCase> cases = new ArrayList<SecurityMonitoringRuleCase>();
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SecurityMonitoringRuleOptions options;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<SecurityMonitoringRuleQuery> queries = new ArrayList<SecurityMonitoringRuleQuery>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = new ArrayList<String>();

    public SecurityMonitoringRuleCreatePayload cases(List<SecurityMonitoringRuleCase> cases) {
        this.cases = cases;
        return this;
    }

    public SecurityMonitoringRuleCreatePayload addCasesItem(SecurityMonitoringRuleCase casesItem) {
        this.cases.add(casesItem);
        return this;
    }

    @ApiModelProperty(example="[]", required=true, value="Cases for generating signals.")
    @JsonProperty(value="cases")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SecurityMonitoringRuleCase> getCases() {
        return this.cases;
    }

    public void setCases(List<SecurityMonitoringRuleCase> cases) {
        this.cases = cases;
    }

    public SecurityMonitoringRuleCreatePayload enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="Whether the rule is enabled.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SecurityMonitoringRuleCreatePayload message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="Message for generated signals.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SecurityMonitoringRuleCreatePayload name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the rule")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityMonitoringRuleCreatePayload options(SecurityMonitoringRuleOptions options) {
        this.options = options;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityMonitoringRuleOptions getOptions() {
        return this.options;
    }

    public void setOptions(SecurityMonitoringRuleOptions options) {
        this.options = options;
    }

    public SecurityMonitoringRuleCreatePayload queries(List<SecurityMonitoringRuleQuery> queries) {
        this.queries = queries;
        return this;
    }

    public SecurityMonitoringRuleCreatePayload addQueriesItem(SecurityMonitoringRuleQuery queriesItem) {
        this.queries.add(queriesItem);
        return this;
    }

    @ApiModelProperty(example="[]", required=true, value="Queries for selecting logs which are part of the rule.")
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SecurityMonitoringRuleQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<SecurityMonitoringRuleQuery> queries) {
        this.queries = queries;
    }

    public SecurityMonitoringRuleCreatePayload tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SecurityMonitoringRuleCreatePayload addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[\"env:prod\",\"team:security\"]", required=true, value="Tags for generated signals.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleCreatePayload securityMonitoringRuleCreatePayload = (SecurityMonitoringRuleCreatePayload)o;
        return Objects.equals(this.cases, securityMonitoringRuleCreatePayload.cases) && Objects.equals(this.enabled, securityMonitoringRuleCreatePayload.enabled) && Objects.equals(this.message, securityMonitoringRuleCreatePayload.message) && Objects.equals(this.name, securityMonitoringRuleCreatePayload.name) && Objects.equals(this.options, securityMonitoringRuleCreatePayload.options) && Objects.equals(this.queries, securityMonitoringRuleCreatePayload.queries) && Objects.equals(this.tags, securityMonitoringRuleCreatePayload.tags);
    }

    public int hashCode() {
        return Objects.hash(this.cases, this.enabled, this.message, this.name, this.options, this.queries, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleCreatePayload {\n");
        sb.append("    cases: ").append(this.toIndentedString(this.cases)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

