/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing the retry strategy to apply to a Synthetic test. By default, there is a 300ms wait before retrying a test that has failed.")
@JsonPropertyOrder(value={"count", "interval"})
public class SyntheticsTestOptionsRetry {
    public static final String JSON_PROPERTY_COUNT = "count";
    private Long count;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private Double interval;

    public SyntheticsTestOptionsRetry count(Long count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of location that needs to fail for the test to be retried.")
    @JsonProperty(value="count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public SyntheticsTestOptionsRetry interval(Double interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The interval over which the amount of location needed to fail for the test to be retried.")
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInterval() {
        return this.interval;
    }

    public void setInterval(Double interval) {
        this.interval = interval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsTestOptionsRetry syntheticsTestOptionsRetry = (SyntheticsTestOptionsRetry)o;
        return Objects.equals(this.count, syntheticsTestOptionsRetry.count) && Objects.equals(this.interval, syntheticsTestOptionsRetry.interval);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.interval);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsTestOptionsRetry {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

