/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Object containing the ordered list of pipeline IDs.")
@JsonPropertyOrder(value={"pipeline_ids"})
public class LogsPipelinesOrder {
    public static final String JSON_PROPERTY_PIPELINE_IDS = "pipeline_ids";
    private List<String> pipelineIds = new ArrayList<String>();

    public LogsPipelinesOrder pipelineIds(List<String> pipelineIds) {
        this.pipelineIds = pipelineIds;
        return this;
    }

    public LogsPipelinesOrder addPipelineIdsItem(String pipelineIdsItem) {
        this.pipelineIds.add(pipelineIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"tags\",\"org_ids\",\"products\"]", required=true, value="Ordered Array of `<PIPELINE_ID>` strings, the order of pipeline IDs in the array define the overall Pipelines order for Datadog.")
    @JsonProperty(value="pipeline_ids")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getPipelineIds() {
        return this.pipelineIds;
    }

    public void setPipelineIds(List<String> pipelineIds) {
        this.pipelineIds = pipelineIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsPipelinesOrder logsPipelinesOrder = (LogsPipelinesOrder)o;
        return Objects.equals(this.pipelineIds, logsPipelinesOrder.pipelineIds);
    }

    public int hashCode() {
        return Objects.hash(this.pipelineIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsPipelinesOrder {\n");
        sb.append("    pipelineIds: ").append(this.toIndentedString(this.pipelineIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

