/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.UsageAnalyzedLogsResponse;
import com.datadog.api.v1.client.model.UsageFargateResponse;
import com.datadog.api.v1.client.model.UsageHostsResponse;
import com.datadog.api.v1.client.model.UsageLambdaResponse;
import com.datadog.api.v1.client.model.UsageLogsByIndexResponse;
import com.datadog.api.v1.client.model.UsageLogsResponse;
import com.datadog.api.v1.client.model.UsageNetworkFlowsResponse;
import com.datadog.api.v1.client.model.UsageNetworkHostsResponse;
import com.datadog.api.v1.client.model.UsageRumSessionsResponse;
import com.datadog.api.v1.client.model.UsageSNMPResponse;
import com.datadog.api.v1.client.model.UsageSummaryResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsAPIResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsBrowserResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsResponse;
import com.datadog.api.v1.client.model.UsageTimeseriesResponse;
import com.datadog.api.v1.client.model.UsageTopAvgMetricsResponse;
import com.datadog.api.v1.client.model.UsageTraceResponse;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class UsageMeteringApi {
    private ApiClient apiClient;

    public UsageMeteringApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsageMeteringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<UsageAnalyzedLogsResponse> getUsageAnalyzedLogsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageAnalyzedLogs");
        }
        String localVarPath = "/api/v1/usage/analyzed_logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageAnalyzedLogs");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageAnalyzedLogsResponse> localVarReturnType = new GenericType<UsageAnalyzedLogsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageAnalyzedLogs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageAnalyzedLogsRequest getUsageAnalyzedLogs() throws ApiException {
        return new APIgetUsageAnalyzedLogsRequest();
    }

    private ApiResponse<UsageFargateResponse> getUsageFargateWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageFargate");
        }
        String localVarPath = "/api/v1/usage/fargate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageFargate");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageFargateResponse> localVarReturnType = new GenericType<UsageFargateResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageFargate", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageFargateRequest getUsageFargate() throws ApiException {
        return new APIgetUsageFargateRequest();
    }

    private ApiResponse<UsageHostsResponse> getUsageHostsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageHosts");
        }
        String localVarPath = "/api/v1/usage/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageHosts");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageHostsResponse> localVarReturnType = new GenericType<UsageHostsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageHosts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageHostsRequest getUsageHosts() throws ApiException {
        return new APIgetUsageHostsRequest();
    }

    private ApiResponse<UsageLambdaResponse> getUsageLambdaWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLambda");
        }
        String localVarPath = "/api/v1/usage/aws_lambda";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLambda");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLambdaResponse> localVarReturnType = new GenericType<UsageLambdaResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLambda", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageLambdaRequest getUsageLambda() throws ApiException {
        return new APIgetUsageLambdaRequest();
    }

    private ApiResponse<UsageLogsResponse> getUsageLogsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLogs");
        }
        String localVarPath = "/api/v1/usage/logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLogs");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLogsResponse> localVarReturnType = new GenericType<UsageLogsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLogs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageLogsRequest getUsageLogs() throws ApiException {
        return new APIgetUsageLogsRequest();
    }

    private ApiResponse<UsageLogsByIndexResponse> getUsageLogsByIndexWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr, List<String> indexName) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLogsByIndex");
        }
        String localVarPath = "/api/v1/usage/logs_by_index";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "index_name", indexName));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLogsByIndex");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLogsByIndexResponse> localVarReturnType = new GenericType<UsageLogsByIndexResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLogsByIndex", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageLogsByIndexRequest getUsageLogsByIndex() throws ApiException {
        return new APIgetUsageLogsByIndexRequest();
    }

    private ApiResponse<UsageNetworkFlowsResponse> getUsageNetworkFlowsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageNetworkFlows");
        }
        String localVarPath = "/api/v1/usage/network_flows";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageNetworkFlows");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageNetworkFlowsResponse> localVarReturnType = new GenericType<UsageNetworkFlowsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageNetworkFlows", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageNetworkFlowsRequest getUsageNetworkFlows() throws ApiException {
        return new APIgetUsageNetworkFlowsRequest();
    }

    private ApiResponse<UsageNetworkHostsResponse> getUsageNetworkHostsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageNetworkHosts");
        }
        String localVarPath = "/api/v1/usage/network_hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageNetworkHosts");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageNetworkHostsResponse> localVarReturnType = new GenericType<UsageNetworkHostsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageNetworkHosts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageNetworkHostsRequest getUsageNetworkHosts() throws ApiException {
        return new APIgetUsageNetworkHostsRequest();
    }

    private ApiResponse<UsageRumSessionsResponse> getUsageRumSessionsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageRumSessions");
        }
        String localVarPath = "/api/v1/usage/rum_sessions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageRumSessions");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageRumSessionsResponse> localVarReturnType = new GenericType<UsageRumSessionsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageRumSessions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageRumSessionsRequest getUsageRumSessions() throws ApiException {
        return new APIgetUsageRumSessionsRequest();
    }

    private ApiResponse<UsageSNMPResponse> getUsageSNMPWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSNMP");
        }
        String localVarPath = "/api/v1/usage/snmp";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSNMP");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSNMPResponse> localVarReturnType = new GenericType<UsageSNMPResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSNMP", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageSNMPRequest getUsageSNMP() throws ApiException {
        return new APIgetUsageSNMPRequest();
    }

    private ApiResponse<UsageSummaryResponse> getUsageSummaryWithHttpInfo(OffsetDateTime startMonth, OffsetDateTime endMonth, Boolean includeOrgDetails) throws ApiException {
        Object localVarPostBody = null;
        if (startMonth == null) {
            throw new ApiException(400, "Missing the required parameter 'startMonth' when calling getUsageSummary");
        }
        String localVarPath = "/api/v1/usage/summary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_org_details", includeOrgDetails));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSummary");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSummaryResponse> localVarReturnType = new GenericType<UsageSummaryResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSummary", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageSummaryRequest getUsageSummary() throws ApiException {
        return new APIgetUsageSummaryRequest();
    }

    private ApiResponse<UsageSyntheticsResponse> getUsageSyntheticsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSynthetics");
        }
        String localVarPath = "/api/v1/usage/synthetics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSynthetics");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsResponse> localVarReturnType = new GenericType<UsageSyntheticsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSynthetics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Deprecated
    public APIgetUsageSyntheticsRequest getUsageSynthetics() throws ApiException {
        return new APIgetUsageSyntheticsRequest();
    }

    private ApiResponse<UsageSyntheticsAPIResponse> getUsageSyntheticsAPIWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSyntheticsAPI");
        }
        String localVarPath = "/api/v1/usage/synthetics_api";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSyntheticsAPI");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsAPIResponse> localVarReturnType = new GenericType<UsageSyntheticsAPIResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSyntheticsAPI", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageSyntheticsAPIRequest getUsageSyntheticsAPI() throws ApiException {
        return new APIgetUsageSyntheticsAPIRequest();
    }

    private ApiResponse<UsageSyntheticsBrowserResponse> getUsageSyntheticsBrowserWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSyntheticsBrowser");
        }
        String localVarPath = "/api/v1/usage/synthetics_browser";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSyntheticsBrowser");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsBrowserResponse> localVarReturnType = new GenericType<UsageSyntheticsBrowserResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSyntheticsBrowser", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageSyntheticsBrowserRequest getUsageSyntheticsBrowser() throws ApiException {
        return new APIgetUsageSyntheticsBrowserRequest();
    }

    private ApiResponse<UsageTimeseriesResponse> getUsageTimeseriesWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageTimeseries");
        }
        String localVarPath = "/api/v1/usage/timeseries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTimeseries");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTimeseriesResponse> localVarReturnType = new GenericType<UsageTimeseriesResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTimeseries", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageTimeseriesRequest getUsageTimeseries() throws ApiException {
        return new APIgetUsageTimeseriesRequest();
    }

    private ApiResponse<UsageTopAvgMetricsResponse> getUsageTopAvgMetricsWithHttpInfo(OffsetDateTime month, List<String> names) throws ApiException {
        Object localVarPostBody = null;
        if (month == null) {
            throw new ApiException(400, "Missing the required parameter 'month' when calling getUsageTopAvgMetrics");
        }
        String localVarPath = "/api/v1/usage/top_avg_metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "month", month));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "names", names));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTopAvgMetrics");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTopAvgMetricsResponse> localVarReturnType = new GenericType<UsageTopAvgMetricsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTopAvgMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageTopAvgMetricsRequest getUsageTopAvgMetrics() throws ApiException {
        return new APIgetUsageTopAvgMetricsRequest();
    }

    private ApiResponse<UsageTraceResponse> getUsageTraceWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageTrace");
        }
        String localVarPath = "/api/v1/usage/traces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTrace");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTraceResponse> localVarReturnType = new GenericType<UsageTraceResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTrace", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUsageTraceRequest getUsageTrace() throws ApiException {
        return new APIgetUsageTraceRequest();
    }

    public class APIgetUsageTraceRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageTraceRequest() {
        }

        public APIgetUsageTraceRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageTraceRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageTraceResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageTraceResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageTraceWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageTopAvgMetricsRequest {
        private OffsetDateTime month;
        private List<String> names;

        private APIgetUsageTopAvgMetricsRequest() {
        }

        public APIgetUsageTopAvgMetricsRequest month(OffsetDateTime month) {
            this.month = month;
            return this;
        }

        public APIgetUsageTopAvgMetricsRequest names(List<String> names) {
            this.names = names;
            return this;
        }

        public UsageTopAvgMetricsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageTopAvgMetricsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageTopAvgMetricsWithHttpInfo(this.month, this.names);
        }
    }

    public class APIgetUsageTimeseriesRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageTimeseriesRequest() {
        }

        public APIgetUsageTimeseriesRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageTimeseriesRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageTimeseriesResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageTimeseriesResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageTimeseriesWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageSyntheticsBrowserRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageSyntheticsBrowserRequest() {
        }

        public APIgetUsageSyntheticsBrowserRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageSyntheticsBrowserRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageSyntheticsBrowserResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageSyntheticsBrowserResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageSyntheticsBrowserWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageSyntheticsAPIRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageSyntheticsAPIRequest() {
        }

        public APIgetUsageSyntheticsAPIRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageSyntheticsAPIRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageSyntheticsAPIResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageSyntheticsAPIResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageSyntheticsAPIWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageSyntheticsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageSyntheticsRequest() {
        }

        public APIgetUsageSyntheticsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageSyntheticsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        @Deprecated
        public UsageSyntheticsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        @Deprecated
        public ApiResponse<UsageSyntheticsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageSyntheticsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageSummaryRequest {
        private OffsetDateTime startMonth;
        private OffsetDateTime endMonth;
        private Boolean includeOrgDetails;

        private APIgetUsageSummaryRequest() {
        }

        public APIgetUsageSummaryRequest startMonth(OffsetDateTime startMonth) {
            this.startMonth = startMonth;
            return this;
        }

        public APIgetUsageSummaryRequest endMonth(OffsetDateTime endMonth) {
            this.endMonth = endMonth;
            return this;
        }

        public APIgetUsageSummaryRequest includeOrgDetails(Boolean includeOrgDetails) {
            this.includeOrgDetails = includeOrgDetails;
            return this;
        }

        public UsageSummaryResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageSummaryResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageSummaryWithHttpInfo(this.startMonth, this.endMonth, this.includeOrgDetails);
        }
    }

    public class APIgetUsageSNMPRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageSNMPRequest() {
        }

        public APIgetUsageSNMPRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageSNMPRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageSNMPResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageSNMPResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageSNMPWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageRumSessionsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageRumSessionsRequest() {
        }

        public APIgetUsageRumSessionsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageRumSessionsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageRumSessionsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageRumSessionsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageRumSessionsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageNetworkHostsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageNetworkHostsRequest() {
        }

        public APIgetUsageNetworkHostsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageNetworkHostsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageNetworkHostsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageNetworkHostsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageNetworkHostsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageNetworkFlowsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageNetworkFlowsRequest() {
        }

        public APIgetUsageNetworkFlowsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageNetworkFlowsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageNetworkFlowsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageNetworkFlowsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageNetworkFlowsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageLogsByIndexRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;
        private List<String> indexName;

        private APIgetUsageLogsByIndexRequest() {
        }

        public APIgetUsageLogsByIndexRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageLogsByIndexRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public APIgetUsageLogsByIndexRequest indexName(List<String> indexName) {
            this.indexName = indexName;
            return this;
        }

        public UsageLogsByIndexResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageLogsByIndexResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageLogsByIndexWithHttpInfo(this.startHr, this.endHr, this.indexName);
        }
    }

    public class APIgetUsageLogsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageLogsRequest() {
        }

        public APIgetUsageLogsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageLogsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageLogsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageLogsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageLogsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageLambdaRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageLambdaRequest() {
        }

        public APIgetUsageLambdaRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageLambdaRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageLambdaResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageLambdaResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageLambdaWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageHostsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageHostsRequest() {
        }

        public APIgetUsageHostsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageHostsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageHostsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageHostsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageHostsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageFargateRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageFargateRequest() {
        }

        public APIgetUsageFargateRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageFargateRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageFargateResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageFargateResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageFargateWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageAnalyzedLogsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageAnalyzedLogsRequest() {
        }

        public APIgetUsageAnalyzedLogsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageAnalyzedLogsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageAnalyzedLogsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageAnalyzedLogsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageAnalyzedLogsWithHttpInfo(this.startHr, this.endHr);
        }
    }
}

