/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Attributes of the created role.")
@JsonPropertyOrder(value={"created_at", "modified_at", "name"})
public class RoleCreateAttributes {
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private OffsetDateTime modifiedAt;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    @Nullable
    @ApiModelProperty(value="Creation time of the role.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(value="Time of last role modification.")
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public RoleCreateAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the role.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleCreateAttributes roleCreateAttributes = (RoleCreateAttributes)o;
        return Objects.equals(this.createdAt, roleCreateAttributes.createdAt) && Objects.equals(this.modifiedAt, roleCreateAttributes.modifiedAt) && Objects.equals(this.name, roleCreateAttributes.name);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.modifiedAt, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleCreateAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

