/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.PermissionsResponse;
import com.datadog.api.v2.client.model.QuerySortOrder;
import com.datadog.api.v2.client.model.UserCreateRequest;
import com.datadog.api.v2.client.model.UserInvitationResponse;
import com.datadog.api.v2.client.model.UserInvitationsRequest;
import com.datadog.api.v2.client.model.UserInvitationsResponse;
import com.datadog.api.v2.client.model.UserResponse;
import com.datadog.api.v2.client.model.UserUpdateRequest;
import com.datadog.api.v2.client.model.UsersResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<UserResponse> createUserWithHttpInfo(UserCreateRequest body) throws ApiException {
        UserCreateRequest localVarPostBody = body;
        String localVarPath = "/api/v2/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createUser");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UserResponse> localVarReturnType = new GenericType<UserResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.createUser", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcreateUserRequest createUser() throws ApiException {
        return new APIcreateUserRequest();
    }

    private ApiResponse<Void> disableUserWithHttpInfo(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling disableUser");
        }
        String localVarPath = "/api/v2/users/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "disableUser");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("UsersApi.disableUser", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public APIdisableUserRequest disableUser(String userId) throws ApiException {
        return new APIdisableUserRequest(userId);
    }

    private ApiResponse<UserInvitationResponse> getInvitationWithHttpInfo(String userInvitationUuid) throws ApiException {
        Object localVarPostBody = null;
        if (userInvitationUuid == null) {
            throw new ApiException(400, "Missing the required parameter 'userInvitationUuid' when calling getInvitation");
        }
        String localVarPath = "/api/v2/user_invitations/{user_invitation_uuid}".replaceAll("\\{user_invitation_uuid\\}", this.apiClient.escapeString(userInvitationUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getInvitation");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UserInvitationResponse> localVarReturnType = new GenericType<UserInvitationResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.getInvitation", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetInvitationRequest getInvitation(String userInvitationUuid) throws ApiException {
        return new APIgetInvitationRequest(userInvitationUuid);
    }

    private ApiResponse<UserResponse> getUserWithHttpInfo(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUser");
        }
        String localVarPath = "/api/v2/users/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getUser");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UserResponse> localVarReturnType = new GenericType<UserResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.getUser", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetUserRequest getUser(String userId) throws ApiException {
        return new APIgetUserRequest(userId);
    }

    private ApiResponse<UserResponse> listUserOrganizationsWithHttpInfo(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listUserOrganizations");
        }
        String localVarPath = "/api/v2/users/{user_id}/orgs".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listUserOrganizations");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UserResponse> localVarReturnType = new GenericType<UserResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.listUserOrganizations", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistUserOrganizationsRequest listUserOrganizations(String userId) throws ApiException {
        return new APIlistUserOrganizationsRequest(userId);
    }

    private ApiResponse<PermissionsResponse> listUserPermissionsWithHttpInfo(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listUserPermissions");
        }
        String localVarPath = "/api/v2/users/{user_id}/permissions".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listUserPermissions");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<PermissionsResponse> localVarReturnType = new GenericType<PermissionsResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.listUserPermissions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistUserPermissionsRequest listUserPermissions(String userId) throws ApiException {
        return new APIlistUserPermissionsRequest(userId);
    }

    private ApiResponse<UsersResponse> listUsersWithHttpInfo(Long pageSize, Long pageNumber, String sort, QuerySortOrder sortDir, String filter, String filterStatus) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", (Object)sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        localVarHeaderParams.put("DD-OPERATION-ID", "listUsers");
        String[] localVarAccepts = new String[]{"application/json", "applcation/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsersResponse> localVarReturnType = new GenericType<UsersResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.listUsers", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistUsersRequest listUsers() throws ApiException {
        return new APIlistUsersRequest();
    }

    private ApiResponse<UserInvitationsResponse> sendInvitationsWithHttpInfo(UserInvitationsRequest body) throws ApiException {
        UserInvitationsRequest localVarPostBody = body;
        String localVarPath = "/api/v2/user_invitations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "sendInvitations");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UserInvitationsResponse> localVarReturnType = new GenericType<UserInvitationsResponse>(){};
        return this.apiClient.invokeAPI("UsersApi.sendInvitations", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIsendInvitationsRequest sendInvitations() throws ApiException {
        return new APIsendInvitationsRequest();
    }

    private ApiResponse<Void> updateUserWithHttpInfo(String userId, UserUpdateRequest body) throws ApiException {
        UserUpdateRequest localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateUser");
        }
        String localVarPath = "/api/v2/users/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateUser");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("UsersApi.updateUser", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public APIupdateUserRequest updateUser(String userId) throws ApiException {
        return new APIupdateUserRequest(userId);
    }

    public class APIupdateUserRequest {
        private String userId;
        private UserUpdateRequest body;

        private APIupdateUserRequest(String userId) {
            this.userId = userId;
        }

        public APIupdateUserRequest body(UserUpdateRequest body) {
            this.body = body;
            return this;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.updateUserWithHttpInfo(this.userId, this.body);
        }
    }

    public class APIsendInvitationsRequest {
        private UserInvitationsRequest body;

        private APIsendInvitationsRequest() {
        }

        public APIsendInvitationsRequest body(UserInvitationsRequest body) {
            this.body = body;
            return this;
        }

        public UserInvitationsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UserInvitationsResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.sendInvitationsWithHttpInfo(this.body);
        }
    }

    public class APIlistUsersRequest {
        private Long pageSize;
        private Long pageNumber;
        private String sort;
        private QuerySortOrder sortDir;
        private String filter;
        private String filterStatus;

        private APIlistUsersRequest() {
        }

        public APIlistUsersRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIlistUsersRequest pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public APIlistUsersRequest sort(String sort) {
            this.sort = sort;
            return this;
        }

        public APIlistUsersRequest sortDir(QuerySortOrder sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public APIlistUsersRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public APIlistUsersRequest filterStatus(String filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        public UsersResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsersResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.listUsersWithHttpInfo(this.pageSize, this.pageNumber, this.sort, this.sortDir, this.filter, this.filterStatus);
        }
    }

    public class APIlistUserPermissionsRequest {
        private String userId;

        private APIlistUserPermissionsRequest(String userId) {
            this.userId = userId;
        }

        public PermissionsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<PermissionsResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.listUserPermissionsWithHttpInfo(this.userId);
        }
    }

    public class APIlistUserOrganizationsRequest {
        private String userId;

        private APIlistUserOrganizationsRequest(String userId) {
            this.userId = userId;
        }

        public UserResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UserResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.listUserOrganizationsWithHttpInfo(this.userId);
        }
    }

    public class APIgetUserRequest {
        private String userId;

        private APIgetUserRequest(String userId) {
            this.userId = userId;
        }

        public UserResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UserResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.getUserWithHttpInfo(this.userId);
        }
    }

    public class APIgetInvitationRequest {
        private String userInvitationUuid;

        private APIgetInvitationRequest(String userInvitationUuid) {
            this.userInvitationUuid = userInvitationUuid;
        }

        public UserInvitationResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UserInvitationResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.getInvitationWithHttpInfo(this.userInvitationUuid);
        }
    }

    public class APIdisableUserRequest {
        private String userId;

        private APIdisableUserRequest(String userId) {
            this.userId = userId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.disableUserWithHttpInfo(this.userId);
        }
    }

    public class APIcreateUserRequest {
        private UserCreateRequest body;

        private APIcreateUserRequest() {
        }

        public APIcreateUserRequest body(UserCreateRequest body) {
            this.body = body;
            return this;
        }

        public UserResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UserResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.createUserWithHttpInfo(this.body);
        }
    }
}

