/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.SecurityMonitoringListRulesResponse;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleCreatePayload;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleResponse;
import com.datadog.api.v2.client.model.SecurityMonitoringRuleUpdatePayload;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class SecurityMonitoringApi {
    private ApiClient apiClient;

    public SecurityMonitoringApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecurityMonitoringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<SecurityMonitoringRuleResponse> createSecurityMonitoringRuleWithHttpInfo(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        SecurityMonitoringRuleCreatePayload localVarPostBody = body;
        String localVarPath = "/api/v2/security_monitoring/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createSecurityMonitoringRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SecurityMonitoringRuleResponse> localVarReturnType = new GenericType<SecurityMonitoringRuleResponse>(){};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.createSecurityMonitoringRule", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcreateSecurityMonitoringRuleRequest createSecurityMonitoringRule() throws ApiException {
        return new APIcreateSecurityMonitoringRuleRequest();
    }

    private ApiResponse<Void> deleteSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteSecurityMonitoringRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.deleteSecurityMonitoringRule", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public APIdeleteSecurityMonitoringRuleRequest deleteSecurityMonitoringRule(String ruleId) throws ApiException {
        return new APIdeleteSecurityMonitoringRuleRequest(ruleId);
    }

    private ApiResponse<SecurityMonitoringRuleResponse> getSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSecurityMonitoringRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SecurityMonitoringRuleResponse> localVarReturnType = new GenericType<SecurityMonitoringRuleResponse>(){};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.getSecurityMonitoringRule", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetSecurityMonitoringRuleRequest getSecurityMonitoringRule(String ruleId) throws ApiException {
        return new APIgetSecurityMonitoringRuleRequest(ruleId);
    }

    private ApiResponse<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesWithHttpInfo(Long pageSize, Long pageNumber) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarHeaderParams.put("DD-OPERATION-ID", "listSecurityMonitoringRules");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SecurityMonitoringListRulesResponse> localVarReturnType = new GenericType<SecurityMonitoringListRulesResponse>(){};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.listSecurityMonitoringRules", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistSecurityMonitoringRulesRequest listSecurityMonitoringRules() throws ApiException {
        return new APIlistSecurityMonitoringRulesRequest();
    }

    private ApiResponse<SecurityMonitoringRuleResponse> updateSecurityMonitoringRuleWithHttpInfo(String ruleId, SecurityMonitoringRuleUpdatePayload body) throws ApiException {
        SecurityMonitoringRuleUpdatePayload localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling updateSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateSecurityMonitoringRule");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SecurityMonitoringRuleResponse> localVarReturnType = new GenericType<SecurityMonitoringRuleResponse>(){};
        return this.apiClient.invokeAPI("SecurityMonitoringApi.updateSecurityMonitoringRule", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIupdateSecurityMonitoringRuleRequest updateSecurityMonitoringRule(String ruleId) throws ApiException {
        return new APIupdateSecurityMonitoringRuleRequest(ruleId);
    }

    public class APIupdateSecurityMonitoringRuleRequest {
        private String ruleId;
        private SecurityMonitoringRuleUpdatePayload body;

        private APIupdateSecurityMonitoringRuleRequest(String ruleId) {
            this.ruleId = ruleId;
        }

        public APIupdateSecurityMonitoringRuleRequest body(SecurityMonitoringRuleUpdatePayload body) {
            this.body = body;
            return this;
        }

        public SecurityMonitoringRuleResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SecurityMonitoringRuleResponse> executeWithHttpInfo() throws ApiException {
            return SecurityMonitoringApi.this.updateSecurityMonitoringRuleWithHttpInfo(this.ruleId, this.body);
        }
    }

    public class APIlistSecurityMonitoringRulesRequest {
        private Long pageSize;
        private Long pageNumber;

        private APIlistSecurityMonitoringRulesRequest() {
        }

        public APIlistSecurityMonitoringRulesRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIlistSecurityMonitoringRulesRequest pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public SecurityMonitoringListRulesResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SecurityMonitoringListRulesResponse> executeWithHttpInfo() throws ApiException {
            return SecurityMonitoringApi.this.listSecurityMonitoringRulesWithHttpInfo(this.pageSize, this.pageNumber);
        }
    }

    public class APIgetSecurityMonitoringRuleRequest {
        private String ruleId;

        private APIgetSecurityMonitoringRuleRequest(String ruleId) {
            this.ruleId = ruleId;
        }

        public SecurityMonitoringRuleResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SecurityMonitoringRuleResponse> executeWithHttpInfo() throws ApiException {
            return SecurityMonitoringApi.this.getSecurityMonitoringRuleWithHttpInfo(this.ruleId);
        }
    }

    public class APIdeleteSecurityMonitoringRuleRequest {
        private String ruleId;

        private APIdeleteSecurityMonitoringRuleRequest(String ruleId) {
            this.ruleId = ruleId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return SecurityMonitoringApi.this.deleteSecurityMonitoringRuleWithHttpInfo(this.ruleId);
        }
    }

    public class APIcreateSecurityMonitoringRuleRequest {
        private SecurityMonitoringRuleCreatePayload body;

        private APIcreateSecurityMonitoringRuleRequest() {
        }

        public APIcreateSecurityMonitoringRuleRequest body(SecurityMonitoringRuleCreatePayload body) {
            this.body = body;
            return this;
        }

        public SecurityMonitoringRuleResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SecurityMonitoringRuleResponse> executeWithHttpInfo() throws ApiException {
            return SecurityMonitoringApi.this.createSecurityMonitoringRuleWithHttpInfo(this.body);
        }
    }
}

