/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Number of RUM Sessions recorded for each hour for a given organization.")
@JsonPropertyOrder(value={"hour", "session_count"})
public class UsageRumSessionsHour {
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_SESSION_COUNT = "session_count";
    private Long sessionCount;

    public UsageRumSessionsHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageRumSessionsHour sessionCount(Long sessionCount) {
        this.sessionCount = sessionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of RUM Sessions.")
    @JsonProperty(value="session_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSessionCount() {
        return this.sessionCount;
    }

    public void setSessionCount(Long sessionCount) {
        this.sessionCount = sessionCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageRumSessionsHour usageRumSessionsHour = (UsageRumSessionsHour)o;
        return Objects.equals(this.hour, usageRumSessionsHour.hour) && Objects.equals(this.sessionCount, usageRumSessionsHour.sessionCount);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.sessionCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageRumSessionsHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    sessionCount: ").append(this.toIndentedString(this.sessionCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

