/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.EventQueryDefinition;
import com.datadog.api.v1.client.model.LogQueryDefinition;
import com.datadog.api.v1.client.model.ProcessQueryDefinition;
import com.datadog.api.v1.client.model.TimeseriesWidgetRequestMetadata;
import com.datadog.api.v1.client.model.WidgetDisplayType;
import com.datadog.api.v1.client.model.WidgetRequestStyle;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Updated timeseries widget.")
@JsonPropertyOrder(value={"apm_query", "display_type", "event_query", "log_query", "metadata", "network_query", "process_query", "q", "rum_query", "style"})
public class TimeseriesWidgetRequest {
    public static final String JSON_PROPERTY_APM_QUERY = "apm_query";
    private LogQueryDefinition apmQuery;
    public static final String JSON_PROPERTY_DISPLAY_TYPE = "display_type";
    private WidgetDisplayType displayType;
    public static final String JSON_PROPERTY_EVENT_QUERY = "event_query";
    private EventQueryDefinition eventQuery;
    public static final String JSON_PROPERTY_LOG_QUERY = "log_query";
    private LogQueryDefinition logQuery;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private List<TimeseriesWidgetRequestMetadata> metadata = null;
    public static final String JSON_PROPERTY_NETWORK_QUERY = "network_query";
    private LogQueryDefinition networkQuery;
    public static final String JSON_PROPERTY_PROCESS_QUERY = "process_query";
    private ProcessQueryDefinition processQuery;
    public static final String JSON_PROPERTY_Q = "q";
    private String q;
    public static final String JSON_PROPERTY_RUM_QUERY = "rum_query";
    private LogQueryDefinition rumQuery;
    public static final String JSON_PROPERTY_STYLE = "style";
    private WidgetRequestStyle style;

    public TimeseriesWidgetRequest apmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="apm_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getApmQuery() {
        return this.apmQuery;
    }

    public void setApmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
    }

    public TimeseriesWidgetRequest displayType(WidgetDisplayType displayType) {
        this.displayType = displayType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="display_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(WidgetDisplayType displayType) {
        this.displayType = displayType;
    }

    public TimeseriesWidgetRequest eventQuery(EventQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="event_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventQueryDefinition getEventQuery() {
        return this.eventQuery;
    }

    public void setEventQuery(EventQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
    }

    public TimeseriesWidgetRequest logQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="log_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getLogQuery() {
        return this.logQuery;
    }

    public void setLogQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
    }

    public TimeseriesWidgetRequest metadata(List<TimeseriesWidgetRequestMetadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    public TimeseriesWidgetRequest addMetadataItem(TimeseriesWidgetRequestMetadata metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<TimeseriesWidgetRequestMetadata>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to define expression aliases.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TimeseriesWidgetRequestMetadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<TimeseriesWidgetRequestMetadata> metadata) {
        this.metadata = metadata;
    }

    public TimeseriesWidgetRequest networkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="network_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getNetworkQuery() {
        return this.networkQuery;
    }

    public void setNetworkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
    }

    public TimeseriesWidgetRequest processQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="process_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessQueryDefinition getProcessQuery() {
        return this.processQuery;
    }

    public void setProcessQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
    }

    public TimeseriesWidgetRequest q(String q) {
        this.q = q;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Widget query.")
    @JsonProperty(value="q")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public TimeseriesWidgetRequest rumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="rum_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getRumQuery() {
        return this.rumQuery;
    }

    public void setRumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
    }

    public TimeseriesWidgetRequest style(WidgetRequestStyle style) {
        this.style = style;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetRequestStyle getStyle() {
        return this.style;
    }

    public void setStyle(WidgetRequestStyle style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeseriesWidgetRequest timeseriesWidgetRequest = (TimeseriesWidgetRequest)o;
        return Objects.equals(this.apmQuery, timeseriesWidgetRequest.apmQuery) && Objects.equals((Object)this.displayType, (Object)timeseriesWidgetRequest.displayType) && Objects.equals(this.eventQuery, timeseriesWidgetRequest.eventQuery) && Objects.equals(this.logQuery, timeseriesWidgetRequest.logQuery) && Objects.equals(this.metadata, timeseriesWidgetRequest.metadata) && Objects.equals(this.networkQuery, timeseriesWidgetRequest.networkQuery) && Objects.equals(this.processQuery, timeseriesWidgetRequest.processQuery) && Objects.equals(this.q, timeseriesWidgetRequest.q) && Objects.equals(this.rumQuery, timeseriesWidgetRequest.rumQuery) && Objects.equals(this.style, timeseriesWidgetRequest.style);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apmQuery, this.displayType, this.eventQuery, this.logQuery, this.metadata, this.networkQuery, this.processQuery, this.q, this.rumQuery, this.style});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeseriesWidgetRequest {\n");
        sb.append("    apmQuery: ").append(this.toIndentedString(this.apmQuery)).append("\n");
        sb.append("    displayType: ").append(this.toIndentedString((Object)this.displayType)).append("\n");
        sb.append("    eventQuery: ").append(this.toIndentedString(this.eventQuery)).append("\n");
        sb.append("    logQuery: ").append(this.toIndentedString(this.logQuery)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    networkQuery: ").append(this.toIndentedString(this.networkQuery)).append("\n");
        sb.append("    processQuery: ").append(this.toIndentedString(this.processQuery)).append("\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    rumQuery: ").append(this.toIndentedString(this.rumQuery)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

