/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsDeviceID;
import com.datadog.api.v1.client.model.SyntheticsTestOptionsRetry;
import com.datadog.api.v1.client.model.SyntheticsTickInterval;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing the extra options for a Synthetic test.")
@JsonPropertyOrder(value={"accept_self_signed", "allow_insecure", "device_ids", "follow_redirects", "min_failure_duration", "min_location_failed", "retry", "tick_every"})
public class SyntheticsTestOptions {
    public static final String JSON_PROPERTY_ACCEPT_SELF_SIGNED = "accept_self_signed";
    private Boolean acceptSelfSigned;
    public static final String JSON_PROPERTY_ALLOW_INSECURE = "allow_insecure";
    private Boolean allowInsecure;
    public static final String JSON_PROPERTY_DEVICE_IDS = "device_ids";
    private List<SyntheticsDeviceID> deviceIds = null;
    public static final String JSON_PROPERTY_FOLLOW_REDIRECTS = "follow_redirects";
    private Boolean followRedirects;
    public static final String JSON_PROPERTY_MIN_FAILURE_DURATION = "min_failure_duration";
    private Long minFailureDuration;
    public static final String JSON_PROPERTY_MIN_LOCATION_FAILED = "min_location_failed";
    private Long minLocationFailed;
    public static final String JSON_PROPERTY_RETRY = "retry";
    private SyntheticsTestOptionsRetry retry;
    public static final String JSON_PROPERTY_TICK_EVERY = "tick_every";
    private SyntheticsTickInterval tickEvery;

    public SyntheticsTestOptions acceptSelfSigned(Boolean acceptSelfSigned) {
        this.acceptSelfSigned = acceptSelfSigned;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For browser test, whether or not the test should allow self signed certificate.")
    @JsonProperty(value="accept_self_signed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAcceptSelfSigned() {
        return this.acceptSelfSigned;
    }

    public void setAcceptSelfSigned(Boolean acceptSelfSigned) {
        this.acceptSelfSigned = acceptSelfSigned;
    }

    public SyntheticsTestOptions allowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows loading insecure content for an HTTP request.")
    @JsonProperty(value="allow_insecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowInsecure() {
        return this.allowInsecure;
    }

    public void setAllowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
    }

    public SyntheticsTestOptions deviceIds(List<SyntheticsDeviceID> deviceIds) {
        this.deviceIds = deviceIds;
        return this;
    }

    public SyntheticsTestOptions addDeviceIdsItem(SyntheticsDeviceID deviceIdsItem) {
        if (this.deviceIds == null) {
            this.deviceIds = new ArrayList<SyntheticsDeviceID>();
        }
        this.deviceIds.add(deviceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array with the different device IDs used to run the test.")
    @JsonProperty(value="device_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsDeviceID> getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(List<SyntheticsDeviceID> deviceIds) {
        this.deviceIds = deviceIds;
    }

    public SyntheticsTestOptions followRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For API SSL test, whether or not the test should follow redirects.")
    @JsonProperty(value="follow_redirects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public SyntheticsTestOptions minFailureDuration(Long minFailureDuration) {
        this.minFailureDuration = minFailureDuration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum amount of time before declaring the test has failed.")
    @JsonProperty(value="min_failure_duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMinFailureDuration() {
        return this.minFailureDuration;
    }

    public void setMinFailureDuration(Long minFailureDuration) {
        this.minFailureDuration = minFailureDuration;
    }

    public SyntheticsTestOptions minLocationFailed(Long minLocationFailed) {
        this.minLocationFailed = minLocationFailed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum amount of locations that are allowed to fail for the test.")
    @JsonProperty(value="min_location_failed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMinLocationFailed() {
        return this.minLocationFailed;
    }

    public void setMinLocationFailed(Long minLocationFailed) {
        this.minLocationFailed = minLocationFailed;
    }

    public SyntheticsTestOptions retry(SyntheticsTestOptionsRetry retry) {
        this.retry = retry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="retry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestOptionsRetry getRetry() {
        return this.retry;
    }

    public void setRetry(SyntheticsTestOptionsRetry retry) {
        this.retry = retry;
    }

    public SyntheticsTestOptions tickEvery(SyntheticsTickInterval tickEvery) {
        this.tickEvery = tickEvery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="tick_every")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTickInterval getTickEvery() {
        return this.tickEvery;
    }

    public void setTickEvery(SyntheticsTickInterval tickEvery) {
        this.tickEvery = tickEvery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsTestOptions syntheticsTestOptions = (SyntheticsTestOptions)o;
        return Objects.equals(this.acceptSelfSigned, syntheticsTestOptions.acceptSelfSigned) && Objects.equals(this.allowInsecure, syntheticsTestOptions.allowInsecure) && Objects.equals(this.deviceIds, syntheticsTestOptions.deviceIds) && Objects.equals(this.followRedirects, syntheticsTestOptions.followRedirects) && Objects.equals(this.minFailureDuration, syntheticsTestOptions.minFailureDuration) && Objects.equals(this.minLocationFailed, syntheticsTestOptions.minLocationFailed) && Objects.equals(this.retry, syntheticsTestOptions.retry) && Objects.equals((Object)this.tickEvery, (Object)syntheticsTestOptions.tickEvery);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptSelfSigned, this.allowInsecure, this.deviceIds, this.followRedirects, this.minFailureDuration, this.minLocationFailed, this.retry, this.tickEvery});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsTestOptions {\n");
        sb.append("    acceptSelfSigned: ").append(this.toIndentedString(this.acceptSelfSigned)).append("\n");
        sb.append("    allowInsecure: ").append(this.toIndentedString(this.allowInsecure)).append("\n");
        sb.append("    deviceIds: ").append(this.toIndentedString(this.deviceIds)).append("\n");
        sb.append("    followRedirects: ").append(this.toIndentedString(this.followRedirects)).append("\n");
        sb.append("    minFailureDuration: ").append(this.toIndentedString(this.minFailureDuration)).append("\n");
        sb.append("    minLocationFailed: ").append(this.toIndentedString(this.minLocationFailed)).append("\n");
        sb.append("    retry: ").append(this.toIndentedString(this.retry)).append("\n");
        sb.append("    tickEvery: ").append(this.toIndentedString((Object)this.tickEvery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

