/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsResourceType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing a resource which is the combination of requests (fetch, XHR) and Assets (HTML, CSS, JS, images).")
@JsonPropertyOrder(value={"duration", "method", "size", "status", "timestamp", "traceId", "type", "url"})
public class SyntheticsResource {
    public static final String JSON_PROPERTY_DURATION = "duration";
    private Double duration;
    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Long size;
    public static final String JSON_PROPERTY_STATUS = "status";
    private Long status;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Double timestamp;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsResourceType type;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public SyntheticsResource duration(Double duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of time the resource was collected.")
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public SyntheticsResource method(String method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HTTP method associated to the resource.")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public SyntheticsResource size(Long size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the resource in bytes.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public SyntheticsResource status(Long status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status Code of the resource.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStatus() {
        return this.status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public SyntheticsResource timestamp(Double timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp of the resource collection.")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Double timestamp) {
        this.timestamp = timestamp;
    }

    public SyntheticsResource traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Trace ID associated with the resource if any.")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public SyntheticsResource type(SyntheticsResourceType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsResourceType getType() {
        return this.type;
    }

    public void setType(SyntheticsResourceType type) {
        this.type = type;
    }

    public SyntheticsResource url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the resource.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsResource syntheticsResource = (SyntheticsResource)o;
        return Objects.equals(this.duration, syntheticsResource.duration) && Objects.equals(this.method, syntheticsResource.method) && Objects.equals(this.size, syntheticsResource.size) && Objects.equals(this.status, syntheticsResource.status) && Objects.equals(this.timestamp, syntheticsResource.timestamp) && Objects.equals(this.traceId, syntheticsResource.traceId) && Objects.equals((Object)this.type, (Object)syntheticsResource.type) && Objects.equals(this.url, syntheticsResource.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.duration, this.method, this.size, this.status, this.timestamp, this.traceId, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsResource {\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

