/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.GroupWidgetDefinitionType;
import com.datadog.api.v1.client.model.Widget;
import com.datadog.api.v1.client.model.WidgetLayoutType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The groups widget allows you to keep similar graphs together on your timeboard. Each group has a custom header, can hold one to many graphs, and is collapsible.")
@JsonPropertyOrder(value={"layout_type", "title", "type", "widgets"})
public class GroupWidgetDefinition {
    public static final String JSON_PROPERTY_LAYOUT_TYPE = "layout_type";
    private WidgetLayoutType layoutType;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private GroupWidgetDefinitionType type = GroupWidgetDefinitionType.GROUP;
    public static final String JSON_PROPERTY_WIDGETS = "widgets";
    private List<Widget> widgets = new ArrayList<Widget>();

    public GroupWidgetDefinition layoutType(WidgetLayoutType layoutType) {
        this.layoutType = layoutType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="layout_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public WidgetLayoutType getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(WidgetLayoutType layoutType) {
        this.layoutType = layoutType;
    }

    public GroupWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public GroupWidgetDefinition type(GroupWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GroupWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(GroupWidgetDefinitionType type) {
        this.type = type;
    }

    public GroupWidgetDefinition widgets(List<Widget> widgets) {
        this.widgets = widgets;
        return this;
    }

    public GroupWidgetDefinition addWidgetsItem(Widget widgetsItem) {
        this.widgets.add(widgetsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"definition\":{\"requests\":{\"fill\":{\"q\":\"system.cpu.user\"}},\"type\":\"hostmap\"}}]", required=true, value="List of widget groups.")
    @JsonProperty(value="widgets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(List<Widget> widgets) {
        this.widgets = widgets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupWidgetDefinition groupWidgetDefinition = (GroupWidgetDefinition)o;
        return Objects.equals((Object)this.layoutType, (Object)groupWidgetDefinition.layoutType) && Objects.equals(this.title, groupWidgetDefinition.title) && Objects.equals((Object)this.type, (Object)groupWidgetDefinition.type) && Objects.equals(this.widgets, groupWidgetDefinition.widgets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.layoutType, this.title, this.type, this.widgets});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupWidgetDefinition {\n");
        sb.append("    layoutType: ").append(this.toIndentedString((Object)this.layoutType)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    widgets: ").append(this.toIndentedString(this.widgets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

