/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.AWSLogsListResponseLambdas;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A list of all Datadog-AWS logs integrations available in your Datadog organization.")
@JsonPropertyOrder(value={"account_id", "lambdas", "services"})
public class AWSLogsListResponse {
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_LAMBDAS = "lambdas";
    private List<AWSLogsListResponseLambdas> lambdas = null;
    public static final String JSON_PROPERTY_SERVICES = "services";
    private List<String> services = null;

    public AWSLogsListResponse accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1234567", value="Your AWS Account ID without dashes.")
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AWSLogsListResponse lambdas(List<AWSLogsListResponseLambdas> lambdas) {
        this.lambdas = lambdas;
        return this;
    }

    public AWSLogsListResponse addLambdasItem(AWSLogsListResponseLambdas lambdasItem) {
        if (this.lambdas == null) {
            this.lambdas = new ArrayList<AWSLogsListResponseLambdas>();
        }
        this.lambdas.add(lambdasItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"arn\":\"arn:aws:lambda:us-east-1:1234567:function:LogsCollectionAPITest\"}]", value="List of ARNs configured in your Datadog account.")
    @JsonProperty(value="lambdas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AWSLogsListResponseLambdas> getLambdas() {
        return this.lambdas;
    }

    public void setLambdas(List<AWSLogsListResponseLambdas> lambdas) {
        this.lambdas = lambdas;
    }

    public AWSLogsListResponse services(List<String> services) {
        this.services = services;
        return this;
    }

    public AWSLogsListResponse addServicesItem(String servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"s3\",\"elb\",\"elbv2\",\"cloudfront\",\"redshift\",\"lambda\"]", value="Array of services IDs.")
    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSLogsListResponse awSLogsListResponse = (AWSLogsListResponse)o;
        return Objects.equals(this.accountId, awSLogsListResponse.accountId) && Objects.equals(this.lambdas, awSLogsListResponse.lambdas) && Objects.equals(this.services, awSLogsListResponse.services);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.lambdas, this.services);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSLogsListResponse {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    lambdas: ").append(this.toIndentedString(this.lambdas)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

