/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.SyntheticsAPITestResultFull;
import com.datadog.api.v1.client.model.SyntheticsBrowserTestResultFull;
import com.datadog.api.v1.client.model.SyntheticsDeleteTestsPayload;
import com.datadog.api.v1.client.model.SyntheticsDeleteTestsResponse;
import com.datadog.api.v1.client.model.SyntheticsGetAPITestLatestResultsResponse;
import com.datadog.api.v1.client.model.SyntheticsGetBrowserTestLatestResultsResponse;
import com.datadog.api.v1.client.model.SyntheticsListTestsResponse;
import com.datadog.api.v1.client.model.SyntheticsLocations;
import com.datadog.api.v1.client.model.SyntheticsTestDetails;
import com.datadog.api.v1.client.model.SyntheticsUpdateTestPauseStatusPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class SyntheticsApi {
    private ApiClient apiClient;

    public SyntheticsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SyntheticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<SyntheticsTestDetails> createTestWithHttpInfo(SyntheticsTestDetails body) throws ApiException {
        SyntheticsTestDetails localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTest");
        }
        String localVarPath = "/api/v1/synthetics/tests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTestDetails> localVarReturnType = new GenericType<SyntheticsTestDetails>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.createTest", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcreateTestRequest createTest() throws ApiException {
        return new APIcreateTestRequest();
    }

    private ApiResponse<SyntheticsDeleteTestsResponse> deleteTestsWithHttpInfo(SyntheticsDeleteTestsPayload body) throws ApiException {
        SyntheticsDeleteTestsPayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteTests");
        }
        String localVarPath = "/api/v1/synthetics/tests/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteTests");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsDeleteTestsResponse> localVarReturnType = new GenericType<SyntheticsDeleteTestsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.deleteTests", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIdeleteTestsRequest deleteTests() throws ApiException {
        return new APIdeleteTestsRequest();
    }

    private ApiResponse<SyntheticsGetAPITestLatestResultsResponse> getAPITestLatestResultsWithHttpInfo(String publicId, Long fromTs, Long toTs, List<String> probeDc) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITestLatestResults");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/results".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "probe_dc", probeDc));
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPITestLatestResults");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGetAPITestLatestResultsResponse> localVarReturnType = new GenericType<SyntheticsGetAPITestLatestResultsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getAPITestLatestResults", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetAPITestLatestResultsRequest getAPITestLatestResults(String publicId) throws ApiException {
        return new APIgetAPITestLatestResultsRequest(publicId);
    }

    private ApiResponse<SyntheticsAPITestResultFull> getAPITestResultWithHttpInfo(String publicId, String resultId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITestResult");
        }
        if (resultId == null) {
            throw new ApiException(400, "Missing the required parameter 'resultId' when calling getAPITestResult");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/results/{result_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString())).replaceAll("\\{result_id\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPITestResult");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsAPITestResultFull> localVarReturnType = new GenericType<SyntheticsAPITestResultFull>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getAPITestResult", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetAPITestResultRequest getAPITestResult(String publicId, String resultId) throws ApiException {
        return new APIgetAPITestResultRequest(publicId, resultId);
    }

    private ApiResponse<SyntheticsTestDetails> getBrowserTestWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getBrowserTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTestDetails> localVarReturnType = new GenericType<SyntheticsTestDetails>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getBrowserTest", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetBrowserTestRequest getBrowserTest(String publicId) throws ApiException {
        return new APIgetBrowserTestRequest(publicId);
    }

    private ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse> getBrowserTestLatestResultsWithHttpInfo(String publicId, Long fromTs, Long toTs, List<String> probeDc) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTestLatestResults");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}/results".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "probe_dc", probeDc));
        localVarHeaderParams.put("DD-OPERATION-ID", "getBrowserTestLatestResults");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGetBrowserTestLatestResultsResponse> localVarReturnType = new GenericType<SyntheticsGetBrowserTestLatestResultsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getBrowserTestLatestResults", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetBrowserTestLatestResultsRequest getBrowserTestLatestResults(String publicId) throws ApiException {
        return new APIgetBrowserTestLatestResultsRequest(publicId);
    }

    private ApiResponse<SyntheticsBrowserTestResultFull> getBrowserTestResultWithHttpInfo(String publicId, String resultId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTestResult");
        }
        if (resultId == null) {
            throw new ApiException(400, "Missing the required parameter 'resultId' when calling getBrowserTestResult");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}/results/{result_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString())).replaceAll("\\{result_id\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getBrowserTestResult");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsBrowserTestResultFull> localVarReturnType = new GenericType<SyntheticsBrowserTestResultFull>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getBrowserTestResult", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetBrowserTestResultRequest getBrowserTestResult(String publicId, String resultId) throws ApiException {
        return new APIgetBrowserTestResultRequest(publicId, resultId);
    }

    private ApiResponse<SyntheticsTestDetails> getTestWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTestDetails> localVarReturnType = new GenericType<SyntheticsTestDetails>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getTest", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetTestRequest getTest(String publicId) throws ApiException {
        return new APIgetTestRequest(publicId);
    }

    private ApiResponse<SyntheticsLocations> listLocationsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/locations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLocations");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsLocations> localVarReturnType = new GenericType<SyntheticsLocations>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.listLocations", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistLocationsRequest listLocations() throws ApiException {
        return new APIlistLocationsRequest();
    }

    private ApiResponse<SyntheticsListTestsResponse> listTestsWithHttpInfo(String checkType) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/tests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "check_type", checkType));
        localVarHeaderParams.put("DD-OPERATION-ID", "listTests");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsListTestsResponse> localVarReturnType = new GenericType<SyntheticsListTestsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.listTests", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistTestsRequest listTests() throws ApiException {
        return new APIlistTestsRequest();
    }

    private ApiResponse<SyntheticsTestDetails> updateTestWithHttpInfo(String publicId, SyntheticsTestDetails body) throws ApiException {
        SyntheticsTestDetails localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateTest");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTestDetails> localVarReturnType = new GenericType<SyntheticsTestDetails>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.updateTest", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIupdateTestRequest updateTest(String publicId) throws ApiException {
        return new APIupdateTestRequest(publicId);
    }

    private ApiResponse<Boolean> updateTestPauseStatusWithHttpInfo(String publicId, SyntheticsUpdateTestPauseStatusPayload body) throws ApiException {
        SyntheticsUpdateTestPauseStatusPayload localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateTestPauseStatus");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTestPauseStatus");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/status".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateTestPauseStatus");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Boolean> localVarReturnType = new GenericType<Boolean>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.updateTestPauseStatus", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIupdateTestPauseStatusRequest updateTestPauseStatus(String publicId) throws ApiException {
        return new APIupdateTestPauseStatusRequest(publicId);
    }

    public class APIupdateTestPauseStatusRequest {
        private String publicId;
        private SyntheticsUpdateTestPauseStatusPayload body;

        private APIupdateTestPauseStatusRequest(String publicId) {
            this.publicId = publicId;
        }

        public APIupdateTestPauseStatusRequest body(SyntheticsUpdateTestPauseStatusPayload body) {
            this.body = body;
            return this;
        }

        public Boolean execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Boolean> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.updateTestPauseStatusWithHttpInfo(this.publicId, this.body);
        }
    }

    public class APIupdateTestRequest {
        private String publicId;
        private SyntheticsTestDetails body;

        private APIupdateTestRequest(String publicId) {
            this.publicId = publicId;
        }

        public APIupdateTestRequest body(SyntheticsTestDetails body) {
            this.body = body;
            return this;
        }

        public SyntheticsTestDetails execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsTestDetails> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.updateTestWithHttpInfo(this.publicId, this.body);
        }
    }

    public class APIlistTestsRequest {
        private String checkType;

        private APIlistTestsRequest() {
        }

        public APIlistTestsRequest checkType(String checkType) {
            this.checkType = checkType;
            return this;
        }

        public SyntheticsListTestsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsListTestsResponse> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.listTestsWithHttpInfo(this.checkType);
        }
    }

    public class APIlistLocationsRequest {
        private APIlistLocationsRequest() {
        }

        public SyntheticsLocations execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsLocations> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.listLocationsWithHttpInfo();
        }
    }

    public class APIgetTestRequest {
        private String publicId;

        private APIgetTestRequest(String publicId) {
            this.publicId = publicId;
        }

        public SyntheticsTestDetails execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsTestDetails> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getTestWithHttpInfo(this.publicId);
        }
    }

    public class APIgetBrowserTestResultRequest {
        private String publicId;
        private String resultId;

        private APIgetBrowserTestResultRequest(String publicId, String resultId) {
            this.publicId = publicId;
            this.resultId = resultId;
        }

        public SyntheticsBrowserTestResultFull execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsBrowserTestResultFull> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getBrowserTestResultWithHttpInfo(this.publicId, this.resultId);
        }
    }

    public class APIgetBrowserTestLatestResultsRequest {
        private String publicId;
        private Long fromTs;
        private Long toTs;
        private List<String> probeDc;

        private APIgetBrowserTestLatestResultsRequest(String publicId) {
            this.publicId = publicId;
        }

        public APIgetBrowserTestLatestResultsRequest fromTs(Long fromTs) {
            this.fromTs = fromTs;
            return this;
        }

        public APIgetBrowserTestLatestResultsRequest toTs(Long toTs) {
            this.toTs = toTs;
            return this;
        }

        public APIgetBrowserTestLatestResultsRequest probeDc(List<String> probeDc) {
            this.probeDc = probeDc;
            return this;
        }

        public SyntheticsGetBrowserTestLatestResultsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getBrowserTestLatestResultsWithHttpInfo(this.publicId, this.fromTs, this.toTs, this.probeDc);
        }
    }

    public class APIgetBrowserTestRequest {
        private String publicId;

        private APIgetBrowserTestRequest(String publicId) {
            this.publicId = publicId;
        }

        public SyntheticsTestDetails execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsTestDetails> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getBrowserTestWithHttpInfo(this.publicId);
        }
    }

    public class APIgetAPITestResultRequest {
        private String publicId;
        private String resultId;

        private APIgetAPITestResultRequest(String publicId, String resultId) {
            this.publicId = publicId;
            this.resultId = resultId;
        }

        public SyntheticsAPITestResultFull execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsAPITestResultFull> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getAPITestResultWithHttpInfo(this.publicId, this.resultId);
        }
    }

    public class APIgetAPITestLatestResultsRequest {
        private String publicId;
        private Long fromTs;
        private Long toTs;
        private List<String> probeDc;

        private APIgetAPITestLatestResultsRequest(String publicId) {
            this.publicId = publicId;
        }

        public APIgetAPITestLatestResultsRequest fromTs(Long fromTs) {
            this.fromTs = fromTs;
            return this;
        }

        public APIgetAPITestLatestResultsRequest toTs(Long toTs) {
            this.toTs = toTs;
            return this;
        }

        public APIgetAPITestLatestResultsRequest probeDc(List<String> probeDc) {
            this.probeDc = probeDc;
            return this;
        }

        public SyntheticsGetAPITestLatestResultsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsGetAPITestLatestResultsResponse> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getAPITestLatestResultsWithHttpInfo(this.publicId, this.fromTs, this.toTs, this.probeDc);
        }
    }

    public class APIdeleteTestsRequest {
        private SyntheticsDeleteTestsPayload body;

        private APIdeleteTestsRequest() {
        }

        public APIdeleteTestsRequest body(SyntheticsDeleteTestsPayload body) {
            this.body = body;
            return this;
        }

        public SyntheticsDeleteTestsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsDeleteTestsResponse> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.deleteTestsWithHttpInfo(this.body);
        }
    }

    public class APIcreateTestRequest {
        private SyntheticsTestDetails body;

        private APIcreateTestRequest() {
        }

        public APIcreateTestRequest body(SyntheticsTestDetails body) {
            this.body = body;
            return this;
        }

        public SyntheticsTestDetails execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsTestDetails> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.createTestWithHttpInfo(this.body);
        }
    }
}

