/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.parsers.dom;

import com.databricks.spark.xml.parsers.dom.DomConfiguration;
import com.databricks.spark.xml.parsers.dom.DomXmlParser;
import com.databricks.spark.xml.parsers.dom.DomXmlParser$;
import com.databricks.spark.xml.parsers.dom.DomXmlPartialSchemaParser$;
import com.databricks.spark.xml.util.InferSchema$;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DomXmlPartialSchemaParser$ {
    public static final DomXmlPartialSchemaParser$ MODULE$;
    private final Logger com$databricks$spark$xml$parsers$dom$DomXmlPartialSchemaParser$$logger;

    static {
        new DomXmlPartialSchemaParser$();
    }

    public Logger com$databricks$spark$xml$parsers$dom$DomXmlPartialSchemaParser$$logger() {
        return this.com$databricks$spark$xml$parsers$dom$DomXmlPartialSchemaParser$$logger;
    }

    public RDD<DataType> parse(RDD<String> xml, double samplingRatio, DomConfiguration conf) {
        Predef$.MODULE$.require(samplingRatio > 0.0, (Function0)new Serializable(samplingRatio){
            public static final long serialVersionUID = 0L;
            private final double samplingRatio$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"samplingRatio (", ") should be greater than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.samplingRatio$1)}));
            }
            {
                this.samplingRatio$1 = samplingRatio$1;
            }
        });
        RDD schemaData = samplingRatio > 0.99 ? xml : xml.sample(false, samplingRatio, 1L);
        boolean failFast = conf.failFastFlag();
        return schemaData.mapPartitions((Function1)new Serializable(conf, failFast){
            public static final long serialVersionUID = 0L;
            public final DomConfiguration conf$1;
            public final boolean failFast$1;

            public final Iterator<DataType> apply(Iterator<String> iter) {
                return iter.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.parse.2 $outer;

                    public final GenTraversableOnce<DataType> apply(String xml) {
                        boolean bl;
                        Throwable throwable2;
                        block3: {
                            Iterable iterable;
                            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                            builder.setErrorHandler(null);
                            try {
                                Node childNode = builder.parse(new ByteArrayInputStream(xml.getBytes())).getChildNodes().item(0);
                                DomXmlParser parser = new DomXmlParser(childNode, this.$outer.conf$1);
                                Object object = parser.isEmpty() ? None$.MODULE$ : BoxedUnit.UNIT;
                                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)DomXmlPartialSchemaParser$.MODULE$.inferObject(parser)));
                            }
                            catch (Throwable throwable2) {
                                Iterable iterable2;
                                bl = false;
                                SAXException sAXException = null;
                                Throwable throwable3 = throwable2;
                                if (!(throwable3 instanceof SAXException)) break block3;
                                bl = true;
                                sAXException = (SAXException)throwable3;
                                if (this.$outer.failFast$1) break block3;
                                DomXmlPartialSchemaParser$.MODULE$.com$databricks$spark$xml$parsers$dom$DomXmlPartialSchemaParser$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping malformed row: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{xml.replaceAll("\n", "")})));
                                iterable = iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                            }
                            return iterable;
                        }
                        if (bl && this.$outer.failFast$1) {
                            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed row (failing fast): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{xml.replaceAll("\n", "")})));
                        }
                        throw throwable2;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$1 = conf$1;
                this.failFast$1 = failFast$1;
            }
        }, schemaData.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
    }

    public DataType com$databricks$spark$xml$parsers$dom$DomXmlPartialSchemaParser$$inferField(DomXmlParser parser, Node node, DomConfiguration conf) {
        return this.inferField(parser.inferDataType(node), parser, node, conf);
    }

    private DataType inferArrayEelementField(DomXmlParser parser, Node node, DomConfiguration conf) {
        return this.inferField(parser.inferArrayElementType(node), parser, node, conf);
    }

    private DataType inferField(int dataType, DomXmlParser parser, Node node, DomConfiguration conf) {
        int n = dataType;
        Object object = DomXmlParser$.MODULE$.INTEGER() == n ? LongType$.MODULE$ : (DomXmlParser$.MODULE$.LONG() == n ? LongType$.MODULE$ : (DomXmlParser$.MODULE$.DOUBLE() == n ? DoubleType$.MODULE$ : (DomXmlParser$.MODULE$.BOOLEAN() == n ? BooleanType$.MODULE$ : (DomXmlParser$.MODULE$.STRING() == n ? StringType$.MODULE$ : (DomXmlParser$.MODULE$.NULL() == n ? NullType$.MODULE$ : (DomXmlParser$.MODULE$.TIMESTAMP() == n ? TimestampType$.MODULE$ : (DomXmlParser$.MODULE$.OBJECT() == n ? this.inferObject(new DomXmlParser(node, conf)) : (DomXmlParser$.MODULE$.ARRAY() == n ? this.partiallyInferArray(parser, node, conf) : StringType$.MODULE$))))))));
        return object;
    }

    public DataType inferObject(DomXmlParser parser) {
        Builder builder = Seq$.MODULE$.newBuilder();
        Map partialInferredArrayTypes = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        parser.foreach(new Serializable(parser, builder, partialInferredArrayTypes){
            public static final long serialVersionUID = 0L;
            private final DomXmlParser parser$1;
            private final Builder builder$1;
            private final Map partialInferredArrayTypes$1;

            public final Builder<Tuple2<String, ArrayBuffer<DataType>>, Iterable<Product>> apply(Node node) {
                Builder builder;
                String field = node.getNodeName();
                DataType inferredType = DomXmlPartialSchemaParser$.MODULE$.com$databricks$spark$xml$parsers$dom$DomXmlPartialSchemaParser$$inferField(this.parser$1, node, this.parser$1.getConf());
                DataType dataType = inferredType;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType st = arrayType.elementType();
                    ArrayBuffer dataTypes = (ArrayBuffer)this.partialInferredArrayTypes$1.getOrElse((Object)field, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ArrayBuffer<DataType> apply() {
                            return (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                        }
                    });
                    dataTypes.$plus$eq((Object)st);
                    builder = this.partialInferredArrayTypes$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)field), (Object)dataTypes));
                } else {
                    builder = this.builder$1.$plus$eq((Object)new StructField(field, DomXmlPartialSchemaParser$.MODULE$.com$databricks$spark$xml$parsers$dom$DomXmlPartialSchemaParser$$inferField(this.parser$1, node, this.parser$1.getConf()), true, StructField$.MODULE$.apply$default$4()));
                }
                return builder;
            }
            {
                this.parser$1 = parser$1;
                this.builder$1 = builder$1;
                this.partialInferredArrayTypes$1 = partialInferredArrayTypes$1;
            }
        });
        partialInferredArrayTypes.foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final Builder builder$1;

            public final Builder<StructField, Seq<StructField>> apply(Tuple2<String, ArrayBuffer<DataType>> x0$1) {
                Tuple2<String, ArrayBuffer<DataType>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String field = (String)tuple2._1();
                    ArrayBuffer dataTypes = (ArrayBuffer)tuple2._2();
                    DataType elementType = (DataType)dataTypes.reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(DataType t1, DataType t2) {
                            return InferSchema$.MODULE$.compatibleType(t1, t2);
                        }
                    });
                    Builder builder = this.builder$1.$plus$eq((Object)new StructField(field, (DataType)ArrayType$.MODULE$.apply(elementType), true, StructField$.MODULE$.apply$default$4()));
                    return builder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return StructType$.MODULE$.apply((Seq)((SeqLike)builder.result()).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$1) {
                return x$1.name();
            }
        }, (Ordering)Ordering.String$.MODULE$));
    }

    public DataType partiallyInferArray(DomXmlParser parser, Node node, DomConfiguration conf) {
        return ArrayType$.MODULE$.apply(this.inferArrayEelementField(parser, node, conf));
    }

    private DomXmlPartialSchemaParser$() {
        MODULE$ = this;
        this.com$databricks$spark$xml$parsers$dom$DomXmlPartialSchemaParser$$logger = LoggerFactory.getLogger(this.getClass());
    }
}

