/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.parsers.dom;

import com.databricks.spark.xml.parsers.dom.DomConfiguration;
import com.databricks.spark.xml.parsers.dom.DomConfiguration$;
import com.databricks.spark.xml.parsers.dom.DomXmlParser;
import com.databricks.spark.xml.parsers.dom.DomXmlParser$;
import com.databricks.spark.xml.util.TypeCast$;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class DomXmlParser$ {
    public static final DomXmlParser$ MODULE$;
    private final Logger com$databricks$spark$xml$parsers$dom$DomXmlParser$$logger;
    private final int FAIL;
    private final int NULL;
    private final int BOOLEAN;
    private final int INTEGER;
    private final int LONG;
    private final int DOUBLE;
    private final int STRING;
    private final int TIMESTAMP;
    private final int OBJECT;
    private final int ARRAY;

    static {
        new DomXmlParser$();
    }

    public Logger com$databricks$spark$xml$parsers$dom$DomXmlParser$$logger() {
        return this.com$databricks$spark$xml$parsers$dom$DomXmlParser$$logger;
    }

    public int FAIL() {
        return this.FAIL;
    }

    public int NULL() {
        return this.NULL;
    }

    public int BOOLEAN() {
        return this.BOOLEAN;
    }

    public int INTEGER() {
        return this.INTEGER;
    }

    public int LONG() {
        return this.LONG;
    }

    public int DOUBLE() {
        return this.DOUBLE;
    }

    public int STRING() {
        return this.STRING;
    }

    public int TIMESTAMP() {
        return this.TIMESTAMP;
    }

    public int OBJECT() {
        return this.OBJECT;
    }

    public int ARRAY() {
        return this.ARRAY;
    }

    public RDD<Row> parse(RDD<String> xml, StructType schema, DomConfiguration conf) {
        boolean failFast = conf.failFastFlag();
        return xml.mapPartitions((Function1)new Serializable(schema, conf, failFast){
            public static final long serialVersionUID = 0L;
            public final StructType schema$1;
            public final DomConfiguration conf$1;
            public final boolean failFast$1;

            public final Iterator<Row> apply(Iterator<String> iter) {
                return iter.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.parse.1 $outer;

                    public final GenTraversableOnce<Row> apply(String xml) {
                        boolean bl;
                        Throwable throwable2;
                        block3: {
                            Iterable iterable;
                            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                            builder.setErrorHandler(null);
                            try {
                                Node childNode = builder.parse(new ByteArrayInputStream(xml.getBytes())).getChildNodes().item(0);
                                DomXmlParser parser = new DomXmlParser(childNode, this.$outer.conf$1);
                                Object object = parser.isEmpty() ? None$.MODULE$ : BoxedUnit.UNIT;
                                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)DomXmlParser$.MODULE$.com$databricks$spark$xml$parsers$dom$DomXmlParser$$convertObject(parser, this.$outer.schema$1)));
                            }
                            catch (Throwable throwable2) {
                                Iterable iterable2;
                                bl = false;
                                SAXException sAXException = null;
                                Throwable throwable3 = throwable2;
                                if (!(throwable3 instanceof SAXException)) break block3;
                                bl = true;
                                sAXException = (SAXException)throwable3;
                                if (this.$outer.failFast$1) break block3;
                                DomXmlParser$.MODULE$.com$databricks$spark$xml$parsers$dom$DomXmlParser$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping malformed row: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{xml.replaceAll("\n", "")})));
                                iterable = iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                            }
                            return iterable;
                        }
                        if (bl && this.$outer.failFast$1) {
                            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed row (failing fast): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{xml.replaceAll("\n", "")})));
                        }
                        throw throwable2;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.schema$1 = schema$1;
                this.conf$1 = conf$1;
                this.failFast$1 = failFast$1;
            }
        }, xml.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
    }

    public Object convertField(Node node, DataType dataType, DomConfiguration conf) {
        DataType dataType2;
        while (true) {
            block19: {
                Long l;
                block4: {
                    Object object;
                    block6: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                block12: {
                                                    block11: {
                                                        block10: {
                                                            block9: {
                                                                block8: {
                                                                    block7: {
                                                                        block5: {
                                                                            block3: {
                                                                                boolean shouldBeNullValue;
                                                                                boolean bl = shouldBeNullValue = node.getTextContent() == null || new StringOps(Predef$.MODULE$.augmentString(node.getTextContent())).size() <= 0 && conf.treatEmptyValuesAsNulls();
                                                                                if (!shouldBeNullValue) break block3;
                                                                                l = null;
                                                                                break block4;
                                                                            }
                                                                            dataType2 = dataType;
                                                                            LongType$ longType$ = LongType$.MODULE$;
                                                                            DataType dataType3 = dataType2;
                                                                            if (longType$ != null ? !longType$.equals(dataType3) : dataType3 != null) break block5;
                                                                            object = BoxesRunTime.boxToLong((long)TypeCast$.MODULE$.signSafeToLong(node.getTextContent()));
                                                                            break block6;
                                                                        }
                                                                        DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                                                        DataType dataType4 = dataType2;
                                                                        if (doubleType$ != null ? !doubleType$.equals(dataType4) : dataType4 != null) break block7;
                                                                        object = BoxesRunTime.boxToDouble((double)TypeCast$.MODULE$.signSafeToDouble(node.getTextContent()));
                                                                        break block6;
                                                                    }
                                                                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                                                    DataType dataType5 = dataType2;
                                                                    if (booleanType$ != null ? !booleanType$.equals(dataType5) : dataType5 != null) break block8;
                                                                    object = TypeCast$.MODULE$.castTo(node.getTextContent(), (DataType)BooleanType$.MODULE$, TypeCast$.MODULE$.castTo$default$3(), TypeCast$.MODULE$.castTo$default$4());
                                                                    break block6;
                                                                }
                                                                StringType$ stringType$ = StringType$.MODULE$;
                                                                DataType dataType6 = dataType2;
                                                                if (stringType$ != null ? !stringType$.equals(dataType6) : dataType6 != null) break block9;
                                                                object = TypeCast$.MODULE$.castTo(node.getTextContent(), (DataType)StringType$.MODULE$, TypeCast$.MODULE$.castTo$default$3(), TypeCast$.MODULE$.castTo$default$4());
                                                                break block6;
                                                            }
                                                            BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                                            DataType dataType7 = dataType2;
                                                            if (binaryType$ != null ? !binaryType$.equals(dataType7) : dataType7 != null) break block10;
                                                            object = TypeCast$.MODULE$.castTo(node.getTextContent(), (DataType)BinaryType$.MODULE$, TypeCast$.MODULE$.castTo$default$3(), TypeCast$.MODULE$.castTo$default$4());
                                                            break block6;
                                                        }
                                                        DateType$ dateType$ = DateType$.MODULE$;
                                                        DataType dataType8 = dataType2;
                                                        if (dateType$ != null ? !dateType$.equals(dataType8) : dataType8 != null) break block11;
                                                        object = TypeCast$.MODULE$.castTo(node.getTextContent(), (DataType)DateType$.MODULE$, TypeCast$.MODULE$.castTo$default$3(), TypeCast$.MODULE$.castTo$default$4());
                                                        break block6;
                                                    }
                                                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                                    DataType dataType9 = dataType2;
                                                    if (timestampType$ != null ? !timestampType$.equals(dataType9) : dataType9 != null) break block12;
                                                    object = TypeCast$.MODULE$.castTo(node.getTextContent(), (DataType)TimestampType$.MODULE$, TypeCast$.MODULE$.castTo$default$3(), TypeCast$.MODULE$.castTo$default$4());
                                                    break block6;
                                                }
                                                FloatType$ floatType$ = FloatType$.MODULE$;
                                                DataType dataType10 = dataType2;
                                                if (floatType$ != null ? !floatType$.equals(dataType10) : dataType10 != null) break block13;
                                                object = BoxesRunTime.boxToFloat((float)TypeCast$.MODULE$.signSafeToFloat(node.getTextContent()));
                                                break block6;
                                            }
                                            ByteType$ byteType$ = ByteType$.MODULE$;
                                            DataType dataType11 = dataType2;
                                            if (byteType$ != null ? !byteType$.equals(dataType11) : dataType11 != null) break block14;
                                            object = TypeCast$.MODULE$.castTo(node.getTextContent(), (DataType)ByteType$.MODULE$, TypeCast$.MODULE$.castTo$default$3(), TypeCast$.MODULE$.castTo$default$4());
                                            break block6;
                                        }
                                        ShortType$ shortType$ = ShortType$.MODULE$;
                                        DataType dataType12 = dataType2;
                                        if (shortType$ != null ? !shortType$.equals(dataType12) : dataType12 != null) break block15;
                                        object = TypeCast$.MODULE$.castTo(node.getTextContent(), (DataType)ShortType$.MODULE$, TypeCast$.MODULE$.castTo$default$3(), TypeCast$.MODULE$.castTo$default$4());
                                        break block6;
                                    }
                                    IntegerType$ integerType$ = IntegerType$.MODULE$;
                                    DataType dataType13 = dataType2;
                                    if (integerType$ != null ? !integerType$.equals(dataType13) : dataType13 != null) break block16;
                                    object = BoxesRunTime.boxToInteger((int)TypeCast$.MODULE$.signSafeToInt(node.getTextContent()));
                                    break block6;
                                }
                                NullType$ nullType$ = NullType$.MODULE$;
                                DataType dataType14 = dataType2;
                                if (nullType$ != null ? !nullType$.equals(dataType14) : dataType14 != null) break block17;
                                object = null;
                                break block6;
                            }
                            if (!(dataType2 instanceof ArrayType)) break block18;
                            ArrayType arrayType = (ArrayType)dataType2;
                            DataType st = arrayType.elementType();
                            object = this.convertPartialArray(node, st, conf);
                            break block6;
                        }
                        if (!(dataType2 instanceof StructType)) break block19;
                        StructType structType = (StructType)dataType2;
                        DomXmlParser nestedParser = new DomXmlParser(node, conf);
                        object = this.com$databricks$spark$xml$parsers$dom$DomXmlParser$$convertObject(nestedParser, structType);
                    }
                    l = object;
                }
                return l;
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse a value for data type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType2})));
    }

    private Object convertPartialArray(Node node, DataType elementType, DomConfiguration conf) {
        return this.convertField(node, elementType, conf);
    }

    public Row com$databricks$spark$xml$parsers$dom$DomXmlParser$$convertObject(DomXmlParser parser, StructType schema) {
        Object[] row = new Object[schema.length()];
        parser.foreach(new Serializable(parser, schema, row){
            public static final long serialVersionUID = 0L;
            private final DomXmlParser parser$1;
            private final StructType schema$2;
            private final Object[] row$1;

            public final void apply(Node node) {
                String field = node.getNodeName();
                Map nameToIndex = ((TraversableOnce)((IterableLike)this.schema$2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(StructField x$4) {
                        return x$4.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                Option option = nameToIndex.get((Object)field);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int index = BoxesRunTime.unboxToInt((Object)some.x());
                    DataType dataType = this.schema$2.apply(index).dataType();
                    DataType dataType2 = dataType;
                    if (dataType2 instanceof ArrayType) {
                        ArrayBuffer values = (ArrayBuffer)Option$.MODULE$.apply(this.row$1[index]).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ArrayBuffer<Object> apply(Object x$5) {
                                return (ArrayBuffer)x$5;
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ArrayBuffer<Object> apply() {
                                return (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                            }
                        });
                        Object newValue = DomXmlParser$.MODULE$.convertField(node, dataType, this.parser$1.getConf());
                        this.row$1[index] = values.$colon$plus(newValue, ArrayBuffer$.MODULE$.canBuildFrom());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.row$1[index] = DomXmlParser$.MODULE$.convertField(node, dataType, this.parser$1.getConf());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new IndexOutOfBoundsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The field ('", "') does not exist in schema"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field})));
            }
            {
                this.parser$1 = parser$1;
                this.schema$2 = schema$2;
                this.row$1 = row$1;
            }
        });
        return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)row));
    }

    public DomConfiguration $lessinit$greater$default$2() {
        return new DomConfiguration(DomConfiguration$.MODULE$.apply$default$1(), DomConfiguration$.MODULE$.apply$default$2(), DomConfiguration$.MODULE$.apply$default$3());
    }

    private DomXmlParser$() {
        MODULE$ = this;
        this.com$databricks$spark$xml$parsers$dom$DomXmlParser$$logger = LoggerFactory.getLogger(this.getClass());
        this.FAIL = -1;
        this.NULL = 1;
        this.BOOLEAN = 2;
        this.INTEGER = 3;
        this.LONG = 4;
        this.DOUBLE = 5;
        this.STRING = 6;
        this.TIMESTAMP = 7;
        this.OBJECT = 8;
        this.ARRAY = 9;
    }
}

