/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml;

import com.databricks.spark.xml.XmlInputFormat$;
import java.lang.reflect.Method;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd!B\u0001\u0003\u0001\tQ!a\u0004-nYJ+7m\u001c:e%\u0016\fG-\u001a:\u000b\u0005\r!\u0011a\u0001=nY*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\t!\u0002Z1uC\n\u0014\u0018nY6t\u0015\u0005I\u0011aA2p[N\u0011\u0001a\u0003\t\u0005\u0019U9R$D\u0001\u000e\u0015\tqq\"A\u0005nCB\u0014X\rZ;dK*\u0011\u0001#E\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0005\u0003-5\u0011ABU3d_J$'+Z1eKJ\u0004\"\u0001G\u000e\u000e\u0003eQ!AG\b\u0002\u0005%|\u0017B\u0001\u000f\u001a\u00051auN\\4Xe&$\u0018M\u00197f!\tAb$\u0003\u0002 3\t!A+\u001a=u\u0011\u0015\t\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u0013\u001d\u0002\u0001\u0019!a\u0001\n\u0013A\u0013\u0001C:uCJ$H+Y4\u0016\u0003%\u00022AK\u00170\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#!B!se\u0006L\bC\u0001\u00161\u0013\t\t4F\u0001\u0003CsR,\u0007\"C\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u00035\u00031\u0019H/\u0019:u)\u0006<w\fJ3r)\t)\u0004\b\u0005\u0002+m%\u0011qg\u000b\u0002\u0005+:LG\u000fC\u0004:e\u0005\u0005\t\u0019A\u0015\u0002\u0007a$\u0013\u0007\u0003\u0004<\u0001\u0001\u0006K!K\u0001\ngR\f'\u000f\u001e+bO\u0002B\u0011\"\u0010\u0001A\u0002\u0003\u0007I\u0011\u0002\u0015\u0002\r\u0015tG\rV1h\u0011%y\u0004\u00011AA\u0002\u0013%\u0001)\u0001\u0006f]\u0012$\u0016mZ0%KF$\"!N!\t\u000fer\u0014\u0011!a\u0001S!11\t\u0001Q!\n%\nq!\u001a8e)\u0006<\u0007\u0005C\u0005F\u0001\u0001\u0007\t\u0019!C\u0005\r\u0006Q1-\u001e:sK:$8*Z=\u0016\u0003]A\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011B%\u0002\u001d\r,(O]3oi.+\u0017p\u0018\u0013fcR\u0011QG\u0013\u0005\bs\u001d\u000b\t\u00111\u0001\u0018\u0011\u0019a\u0005\u0001)Q\u0005/\u0005Y1-\u001e:sK:$8*Z=!\u0011%q\u0005\u00011AA\u0002\u0013%q*\u0001\u0007dkJ\u0014XM\u001c;WC2,X-F\u0001\u001e\u0011%\t\u0006\u00011AA\u0002\u0013%!+\u0001\tdkJ\u0014XM\u001c;WC2,Xm\u0018\u0013fcR\u0011Qg\u0015\u0005\bsA\u000b\t\u00111\u0001\u001e\u0011\u0019)\u0006\u0001)Q\u0005;\u0005i1-\u001e:sK:$h+\u00197vK\u0002B\u0011b\u0016\u0001A\u0002\u0003\u0007I\u0011\u0002-\u0002\u000bM$\u0018M\u001d;\u0016\u0003e\u0003\"A\u000b.\n\u0005m[#\u0001\u0002'p]\u001eD\u0011\"\u0018\u0001A\u0002\u0003\u0007I\u0011\u00020\u0002\u0013M$\u0018M\u001d;`I\u0015\fHCA\u001b`\u0011\u001dID,!AA\u0002eCa!\u0019\u0001!B\u0013I\u0016AB:uCJ$\b\u0005C\u0005d\u0001\u0001\u0007\t\u0019!C\u00051\u0006\u0019QM\u001c3\t\u0013\u0015\u0004\u0001\u0019!a\u0001\n\u00131\u0017aB3oI~#S-\u001d\u000b\u0003k\u001dDq!\u000f3\u0002\u0002\u0003\u0007\u0011\f\u0003\u0004j\u0001\u0001\u0006K!W\u0001\u0005K:$\u0007\u0005C\u0005l\u0001\u0001\u0007\t\u0019!C\u0005Y\u0006!am]5o+\u0005i\u0007C\u00018r\u001b\u0005y'B\u00019\u0010\u0003\t17/\u0003\u0002s_\n\tbi\u0015#bi\u0006Le\u000e];u'R\u0014X-Y7\t\u0013Q\u0004\u0001\u0019!a\u0001\n\u0013)\u0018\u0001\u00034tS:|F%Z9\u0015\u0005U2\bbB\u001dt\u0003\u0003\u0005\r!\u001c\u0005\u0007q\u0002\u0001\u000b\u0015B7\u0002\u000b\u0019\u001c\u0018N\u001c\u0011\t\u000fi\u0004!\u0019!C\u0005w\u00061!-\u001e4gKJ,\u0012\u0001 \t\u00031uL!A`\r\u0003!\u0011\u000bG/Y(viB,HOQ;gM\u0016\u0014\bbBA\u0001\u0001\u0001\u0006I\u0001`\u0001\bEV4g-\u001a:!\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\t!\"\u001b8ji&\fG.\u001b>f)\u0015)\u0014\u0011BA\n\u0011!\tY!a\u0001A\u0002\u00055\u0011!B:qY&$\bc\u0001\u0007\u0002\u0010%\u0019\u0011\u0011C\u0007\u0003\u0015%s\u0007/\u001e;Ta2LG\u000f\u0003\u0005\u0002\u0016\u0005\r\u0001\u0019AA\f\u0003\u001d\u0019wN\u001c;fqR\u00042\u0001DA\r\u0013\r\tY\"\u0004\u0002\u0013)\u0006\u001c8.\u0011;uK6\u0004HoQ8oi\u0016DH\u000fC\u0004\u0002 \u0001!\t%!\t\u0002\u00199,\u0007\u0010^&fsZ\u000bG.^3\u0015\u0005\u0005\r\u0002c\u0001\u0016\u0002&%\u0019\u0011qE\u0016\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0006\u0001\u0005\n\u00055\u0012\u0001\u00028fqR$b!a\t\u00020\u0005M\u0002bBA\u0019\u0003S\u0001\raF\u0001\u0004W\u0016L\bbBA\u001b\u0003S\u0001\r!H\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003s\u0001A\u0011BA\u001e\u00039\u0011X-\u00193V]RLG.T1uG\"$b!a\t\u0002>\u0005\u0005\u0003bBA \u0003o\u0001\r!K\u0001\u0004[\u0006$\b\u0002CA\"\u0003o\u0001\r!a\t\u0002\u0017]LG\u000f[5o\u00052|7m\u001b\u0005\b\u0003\u000f\u0002A\u0011IA%\u0003-9W\r\u001e)s_\u001e\u0014Xm]:\u0015\u0005\u0005-\u0003c\u0001\u0016\u0002N%\u0019\u0011qJ\u0016\u0003\u000b\u0019cw.\u0019;\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V\u0005iq-\u001a;DkJ\u0014XM\u001c;LKf$\u0012a\u0006\u0005\b\u00033\u0002A\u0011IA.\u0003=9W\r^\"veJ,g\u000e\u001e,bYV,G#A\u000f\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b\u0005)1\r\\8tKR\tQ\u0007")
public class XmlRecordReader
extends RecordReader<LongWritable, Text> {
    private byte[] startTag;
    private byte[] endTag;
    private LongWritable currentKey;
    private Text currentValue;
    private long start;
    private long end;
    private FSDataInputStream fsin;
    private final DataOutputBuffer buffer = new DataOutputBuffer();

    private byte[] startTag() {
        return this.startTag;
    }

    private void startTag_$eq(byte[] x$1) {
        this.startTag = x$1;
    }

    private byte[] endTag() {
        return this.endTag;
    }

    private void endTag_$eq(byte[] x$1) {
        this.endTag = x$1;
    }

    private LongWritable currentKey() {
        return this.currentKey;
    }

    private void currentKey_$eq(LongWritable x$1) {
        this.currentKey = x$1;
    }

    private Text currentValue() {
        return this.currentValue;
    }

    private void currentValue_$eq(Text x$1) {
        this.currentValue = x$1;
    }

    private long start() {
        return this.start;
    }

    private void start_$eq(long x$1) {
        this.start = x$1;
    }

    private long end() {
        return this.end;
    }

    private void end_$eq(long x$1) {
        this.end = x$1;
    }

    private FSDataInputStream fsin() {
        return this.fsin;
    }

    private void fsin_$eq(FSDataInputStream x$1) {
        this.fsin = x$1;
    }

    private DataOutputBuffer buffer() {
        return this.buffer;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) {
        FileSplit fileSplit = (FileSplit)split;
        Method method = context.getClass().getMethod("getConfiguration", new Class[0]);
        Configuration conf = (Configuration)method.invoke((Object)context, new Object[0]);
        FileSystem fs = fileSplit.getPath().getFileSystem(conf);
        this.startTag_$eq(conf.get(XmlInputFormat$.MODULE$.START_TAG_KEY()).getBytes(Charsets.UTF_8));
        this.endTag_$eq(conf.get(XmlInputFormat$.MODULE$.END_TAG_KEY()).getBytes(Charsets.UTF_8));
        Predef$.MODULE$.require(this.startTag() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The start tag cannot be null.";
            }
        });
        Predef$.MODULE$.require(this.endTag() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The end tag cannot be null.";
            }
        });
        this.start_$eq(fileSplit.getStart());
        this.end_$eq(this.start() + fileSplit.getLength());
        this.fsin_$eq(fs.open(fileSplit.getPath()));
        this.fsin().seek(this.start());
    }

    public boolean nextKeyValue() {
        this.currentKey_$eq(new LongWritable());
        this.currentValue_$eq(new Text());
        return this.next(this.currentKey(), this.currentValue());
    }

    private boolean next(LongWritable key, Text value) {
        boolean bl;
        if (this.fsin().getPos() < this.end() && this.readUntilMatch(this.startTag(), false)) {
            this.buffer().write(this.startTag());
            if (this.readUntilMatch(this.endTag(), true)) {
                key.set(this.fsin().getPos());
                value.set(this.buffer().getData(), 0, this.buffer().getLength());
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
        finally {
            this.buffer().reset();
        }
    }

    private boolean readUntilMatch(byte[] mat, boolean withinBlock) {
        int i = 0;
        do {
            int b;
            if ((b = this.fsin().read()) == -1) {
                return false;
            }
            if (withinBlock) {
                this.buffer().write(b);
            }
            if (b == mat[i]) {
                if (++i < mat.length) continue;
                return true;
            }
            if (i == mat.length - 1 && b == 32 && !withinBlock) {
                this.startTag()[this.startTag().length - 1] = 32;
                return true;
            }
            i = 0;
        } while (withinBlock || i != 0 || this.fsin().getPos() < this.end());
        return false;
    }

    public float getProgress() {
        return (float)((double)(this.fsin().getPos() - this.start()) / (double)(this.end() - this.start()));
    }

    public LongWritable getCurrentKey() {
        return this.currentKey();
    }

    public Text getCurrentValue() {
        return this.currentValue();
    }

    public void close() {
        this.fsin().close();
    }
}

