/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.http;

import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.HttpClientType;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClient;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.concurrent.ConcurrentHashMap;

public class DatabricksHttpClientFactory {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksHttpClientFactory.class);
    private static final DatabricksHttpClientFactory INSTANCE = new DatabricksHttpClientFactory();
    private final ConcurrentHashMap<AbstractMap.SimpleEntry<String, HttpClientType>, DatabricksHttpClient> instances = new ConcurrentHashMap();

    private DatabricksHttpClientFactory() {
    }

    public static DatabricksHttpClientFactory getInstance() {
        return INSTANCE;
    }

    public IDatabricksHttpClient getClient(IDatabricksConnectionContext context) {
        return this.getClient(context, HttpClientType.COMMON);
    }

    public IDatabricksHttpClient getClient(IDatabricksConnectionContext context, HttpClientType type) {
        return this.instances.computeIfAbsent(this.getClientKey(context.getConnectionUuid(), type), k -> new DatabricksHttpClient(context, type));
    }

    public void removeClient(IDatabricksConnectionContext context) {
        for (HttpClientType type : HttpClientType.values()) {
            this.removeClient(context, type);
        }
    }

    public void removeClient(IDatabricksConnectionContext context, HttpClientType type) {
        DatabricksHttpClient instance = this.instances.remove(this.getClientKey(context.getConnectionUuid(), type));
        if (instance != null) {
            try {
                instance.close();
            }
            catch (IOException e) {
                LOGGER.debug("Caught error while closing http client. Error {}", e);
            }
        }
    }

    private AbstractMap.SimpleEntry<String, HttpClientType> getClientKey(String uuid, HttpClientType clientType) {
        return new AbstractMap.SimpleEntry<String, HttpClientType>(uuid, clientType);
    }
}

