/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.sdk.core.UserAgent;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.util.DriverUtil;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class UserAgentManager {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(UserAgentManager.class);
    private static final String SDK_USER_AGENT = "databricks-sdk-java";
    private static final String JDBC_HTTP_USER_AGENT = "databricks-jdbc-http";
    private static final String DEFAULT_USER_AGENT = "DatabricksJDBCDriverOSS";
    private static final String CLIENT_USER_AGENT_PREFIX = "Java";
    public static final String USER_AGENT_SEA_CLIENT = "SQLExecHttpClient";
    public static final String USER_AGENT_THRIFT_CLIENT = "THttpClient";
    private static final String VERSION_FILLER = "version";

    private static String[] parseCustomerUserAgent(String customerUserAgent) {
        try {
            String decodedUA = URLDecoder.decode(customerUserAgent, StandardCharsets.UTF_8);
            int i = decodedUA.indexOf(47);
            String customerName = i < 0 ? decodedUA : decodedUA.substring(0, i);
            String customerVersion = i < 0 ? VERSION_FILLER : decodedUA.substring(i + 1);
            return new String[]{customerName, customerVersion};
        }
        catch (Exception e) {
            LOGGER.debug("Failed to parse customer userAgent entry {}, Error {}", customerUserAgent, e);
            return null;
        }
    }

    public static void setUserAgent(IDatabricksConnectionContext connectionContext) {
        String[] parsed;
        UserAgent.withProduct(DEFAULT_USER_AGENT, DriverUtil.getDriverVersion());
        UserAgent.withOtherInfo(CLIENT_USER_AGENT_PREFIX, connectionContext.getClientUserAgent());
        if (connectionContext.getCustomerUserAgent() != null && (parsed = UserAgentManager.parseCustomerUserAgent(connectionContext.getCustomerUserAgent())) != null) {
            try {
                UserAgent.withOtherInfo(parsed[0], UserAgent.sanitize(parsed[1]));
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Failed to set user agent for customer userAgent entry {}, Error {}", connectionContext.getCustomerUserAgent(), e);
            }
        }
    }

    public static String buildUserAgentForConnectorService(IDatabricksConnectionContext connectionContext) {
        String[] parsed;
        StringBuilder userAgent = new StringBuilder();
        userAgent.append(DEFAULT_USER_AGENT).append("/").append(DriverUtil.getDriverVersion());
        userAgent.append(" ").append(JDBC_HTTP_USER_AGENT);
        userAgent.append(" jvm/").append(System.getProperty("java.version", "unknown").replace(" ", "_"));
        userAgent.append(" os/").append(System.getProperty("os.name", "unknown").replace(" ", "_"));
        if (connectionContext.getCustomerUserAgent() != null && (parsed = UserAgentManager.parseCustomerUserAgent(connectionContext.getCustomerUserAgent())) != null) {
            try {
                userAgent.append(" ").append(parsed[0]).append("/").append(UserAgent.sanitize(parsed[1]));
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Failed to include customer userAgent entry {} in connector service UA, Error {}", connectionContext.getCustomerUserAgent(), e);
            }
        }
        return userAgent.toString();
    }

    public static String getUserAgentString() {
        String sdkUserAgent = UserAgent.asString();
        String[] parts = sdkUserAgent.split("\\s+");
        StringBuilder mergedString = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].startsWith(SDK_USER_AGENT)) {
                mergedString.append(JDBC_HTTP_USER_AGENT);
            } else {
                mergedString.append(parts[i]);
            }
            if (i == parts.length - 1) continue;
            mergedString.append(" ");
        }
        return mergedString.toString();
    }
}

