/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.safe;

import com.databricks.internal.apache.http.client.methods.CloseableHttpResponse;
import com.databricks.internal.apache.http.client.methods.HttpGet;
import com.databricks.internal.apache.http.util.EntityUtils;
import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.google.common.cache.Cache;
import com.databricks.internal.google.common.cache.CacheBuilder;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.DatabricksClientConfiguratorManager;
import com.databricks.jdbc.common.safe.FeatureFlagsResponse;
import com.databricks.jdbc.common.util.DriverUtil;
import com.databricks.jdbc.common.util.JsonUtil;
import com.databricks.jdbc.common.util.UserAgentManager;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClientFactory;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DatabricksDriverFeatureFlagsContext {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksDriverFeatureFlagsContext.class);
    private static final String FEATURE_FLAGS_ENDPOINT_SUFFIX = String.format("/api/2.0/connector-service/feature-flags/OSS_JDBC/%s", DriverUtil.getDriverVersionWithoutOSSSuffix());
    private static final int DEFAULT_TTL_SECONDS = 900;
    private final String featureFlagEndpoint;
    private final IDatabricksConnectionContext connectionContext;
    private final Cache<String, String> featureFlags;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t2 = new Thread(r, "databricks-jdbc-feature-flags-refresh");
        t2.setDaemon(true);
        return t2;
    });
    private ScheduledFuture<?> scheduledRefreshTask;
    private volatile int refreshIntervalSeconds = 900;

    public DatabricksDriverFeatureFlagsContext(IDatabricksConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.featureFlags = CacheBuilder.newBuilder().build();
        this.featureFlagEndpoint = String.format("https://%s%s", connectionContext.getHostForOAuth(), FEATURE_FLAGS_ENDPOINT_SUFFIX);
        this.refreshAllFeatureFlags();
        this.scheduleOrRescheduleRefresh(900);
    }

    DatabricksDriverFeatureFlagsContext(IDatabricksConnectionContext connectionContext, Map<String, String> initialFlags) {
        this.connectionContext = connectionContext;
        this.featureFlags = CacheBuilder.newBuilder().build();
        this.featureFlagEndpoint = String.format("https://%s%s", connectionContext.getHostForOAuth(), FEATURE_FLAGS_ENDPOINT_SUFFIX);
        initialFlags.forEach(this.featureFlags::put);
        this.scheduleOrRescheduleRefresh(900);
    }

    private void scheduleOrRescheduleRefresh(int ttlSeconds) {
        int n = this.refreshIntervalSeconds = ttlSeconds > 0 ? ttlSeconds : 900;
        if (this.scheduler.isShutdown()) {
            return;
        }
        if (this.scheduledRefreshTask != null && !this.scheduledRefreshTask.isCancelled()) {
            this.scheduledRefreshTask.cancel(false);
        }
        this.scheduledRefreshTask = this.scheduler.scheduleAtFixedRate(this::refreshAllFeatureFlags, this.refreshIntervalSeconds, this.refreshIntervalSeconds, TimeUnit.SECONDS);
    }

    private void refreshAllFeatureFlags() {
        try {
            IDatabricksHttpClient httpClient = DatabricksHttpClientFactory.getInstance().getClient(this.connectionContext);
            HttpGet request = new HttpGet(this.featureFlagEndpoint);
            String userAgent = UserAgentManager.buildUserAgentForConnectorService(this.connectionContext);
            request.setHeader("User-Agent", userAgent);
            DatabricksClientConfiguratorManager.getInstance().getConfigurator(this.connectionContext).getDatabricksConfig().authenticate().forEach(request::addHeader);
            this.fetchAndSetFlagsFromServer(httpClient, request);
        }
        catch (Exception e) {
            LOGGER.trace("Error fetching feature flags for context: {}. Error: {}", this.connectionContext, e.getMessage());
        }
    }

    @VisibleForTesting
    void fetchAndSetFlagsFromServer(IDatabricksHttpClient httpClient, HttpGet request) throws DatabricksHttpException, IOException {
        try (CloseableHttpResponse response = httpClient.execute(request);){
            if (response.getStatusLine().getStatusCode() == 200) {
                Integer ttlSeconds;
                String responseBody = EntityUtils.toString(response.getEntity());
                FeatureFlagsResponse featureFlagsResponse = JsonUtil.getMapper().readValue(responseBody, FeatureFlagsResponse.class);
                this.featureFlags.invalidateAll();
                if (featureFlagsResponse.getFlags() != null) {
                    for (FeatureFlagsResponse.FeatureFlagEntry flag : featureFlagsResponse.getFlags()) {
                        this.featureFlags.put(flag.getName(), flag.getValue());
                    }
                }
                if ((ttlSeconds = featureFlagsResponse.getTtlSeconds()) != null) {
                    this.scheduleOrRescheduleRefresh(ttlSeconds);
                }
            } else {
                LOGGER.trace("Failed to fetch feature flags. Context: {}, Status code: {}", this.connectionContext, response.getStatusLine().getStatusCode());
            }
        }
    }

    public boolean isFeatureEnabled(String name) {
        String value = this.featureFlags.getIfPresent(name);
        return Boolean.parseBoolean(value);
    }

    public void shutdown() {
        ScheduledFuture<?> task = this.scheduledRefreshTask;
        if (task != null) {
            task.cancel(false);
        }
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.scheduler.shutdownNow();
        }
    }
}

