/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.jdbc.api.impl.arrow.ArrowResultChunk;
import com.databricks.jdbc.api.impl.arrow.ChunkLinkFetcher;
import com.databricks.jdbc.api.impl.arrow.ChunkStatus;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.io.IOException;
import java.util.concurrent.Callable;

public class StreamingChunkDownloadTask
implements Callable<Void> {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(StreamingChunkDownloadTask.class);
    private static final int MAX_RETRIES = 5;
    private static final long RETRY_DELAY_MS = 1500L;
    private final ArrowResultChunk chunk;
    private final IDatabricksHttpClient httpClient;
    private final CompressionCodec compressionCodec;
    private final ChunkLinkFetcher linkFetcher;
    private final double cloudFetchSpeedThreshold;

    public StreamingChunkDownloadTask(ArrowResultChunk chunk, IDatabricksHttpClient httpClient, CompressionCodec compressionCodec, ChunkLinkFetcher linkFetcher, double cloudFetchSpeedThreshold) {
        this.chunk = chunk;
        this.httpClient = httpClient;
        this.compressionCodec = compressionCodec;
        this.linkFetcher = linkFetcher;
        this.cloudFetchSpeedThreshold = cloudFetchSpeedThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void call() throws DatabricksSQLException {
        int retries = 0;
        boolean downloadSuccessful = false;
        try {
            while (!downloadSuccessful) {
                try {
                    if (this.chunk.isChunkLinkInvalid()) {
                        LOGGER.debug("Link invalid for chunk {}, refetching", this.chunk.getChunkIndex());
                        ExternalLink freshLink = this.linkFetcher.refetchLink(this.chunk.getChunkIndex(), this.chunk.getStartRowOffset());
                        this.chunk.setChunkLink(freshLink);
                    }
                    this.chunk.downloadData(this.httpClient, this.compressionCodec, this.cloudFetchSpeedThreshold);
                    downloadSuccessful = true;
                    LOGGER.debug("Successfully downloaded chunk {}", this.chunk.getChunkIndex());
                }
                catch (DatabricksSQLException | IOException e) {
                    if (++retries >= 5) {
                        LOGGER.error("Failed to download chunk {} after {} attempts: {}", this.chunk.getChunkIndex(), 5, e.getMessage());
                        throw new DatabricksSQLException(String.format("Failed to download chunk %d after %d attempts", this.chunk.getChunkIndex(), 5), (Throwable)e, DatabricksDriverErrorCode.CHUNK_DOWNLOAD_ERROR);
                    }
                    LOGGER.warn("Retry {} for chunk {}: {}", retries, this.chunk.getChunkIndex(), e.getMessage());
                    this.chunk.setStatus(ChunkStatus.DOWNLOAD_RETRY);
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new DatabricksSQLException("Chunk download interrupted", (Throwable)ie, DatabricksDriverErrorCode.THREAD_INTERRUPTED_ERROR);
                        return null;
                    }
                }
            }
        }
        finally {
            if (downloadSuccessful) {
                this.chunk.getChunkReadyFuture().complete(null);
            } else {
                this.chunk.setStatus(ChunkStatus.DOWNLOAD_FAILED);
                this.chunk.getChunkReadyFuture().completeExceptionally(new DatabricksSQLException("Download failed for chunk " + this.chunk.getChunkIndex(), DatabricksDriverErrorCode.CHUNK_DOWNLOAD_ERROR));
            }
        }
    }
}

