/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.sdk.service.sql.StatementState;
import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.impl.converters.ConverterHelper;
import com.databricks.jdbc.api.internal.IDatabricksConnectionInternal;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.common.CommandName;
import com.databricks.jdbc.common.MetadataResultConstants;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.common.util.DriverUtil;
import com.databricks.jdbc.common.util.WildcardUtil;
import com.databricks.jdbc.dbclient.impl.common.MetadataResultSetBuilder;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.dbclient.impl.sqlexec.ResultConstants;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.core.StatementStatus;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DatabricksDatabaseMetaData
implements DatabaseMetaData {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksDatabaseMetaData.class);
    public static final String DRIVER_NAME = "DatabricksJDBC";
    public static final String PRODUCT_NAME = "SparkSQL";
    public static final int DATABASE_MAJOR_VERSION = 3;
    public static final int DATABASE_MINOR_VERSION = 1;
    public static final int DATABASE_PATCH_VERSION = 1;
    public static final Integer MAX_NAME_LENGTH = 128;
    public static final String NUMERIC_FUNCTIONS = "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    public static final String STRING_FUNCTIONS = "ASCII,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,INSERT,LCASE,LEFT,LENGTH,LOCATE,LOCATE2,LTRIM,OCTET_LENGTH,POSITION,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    public static final String SYSTEM_FUNCTIONS = "DATABASE,IFNULL,USER";
    public static final String TIME_DATE_FUNCTIONS = "CURDATE,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    private final IDatabricksConnectionInternal connection;
    private final IDatabricksSession session;
    private final MetadataResultSetBuilder metadataResultSetBuilder;

    public DatabricksDatabaseMetaData(IDatabricksConnectionInternal connection) {
        this.connection = connection;
        this.session = connection.getSession();
        this.metadataResultSetBuilder = new MetadataResultSetBuilder(this.session.getConnectionContext());
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        LOGGER.debug("public boolean allProceduresAreCallable()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        LOGGER.debug("public boolean allTablesAreSelectable()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        LOGGER.debug("public String getURL()");
        return this.session.getConnectionContext().getConnectionURL();
    }

    @Override
    public String getUserName() throws SQLException {
        LOGGER.debug("public String getUserName()");
        this.throwExceptionIfConnectionIsClosed();
        return "User";
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        LOGGER.debug("public boolean isReadOnly()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        LOGGER.debug("public boolean nullsAreSortedHigh()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        LOGGER.debug("public boolean nullsAreSortedLow()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        LOGGER.debug("public boolean nullsAreSortedAtStart()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        LOGGER.debug("public boolean nullsAreSortedAtEnd()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        LOGGER.debug("public String getDatabaseProductName()");
        this.throwExceptionIfConnectionIsClosed();
        return PRODUCT_NAME;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        LOGGER.debug("public String getDatabaseProductVersion()");
        this.throwExceptionIfConnectionIsClosed();
        return "3.1.1";
    }

    @Override
    public String getDriverName() throws SQLException {
        LOGGER.debug("public String getDriverName()");
        this.throwExceptionIfConnectionIsClosed();
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        LOGGER.debug("public String getDriverVersion()");
        this.throwExceptionIfConnectionIsClosed();
        return DriverUtil.getDriverVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return DriverUtil.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return DriverUtil.getDriverMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        LOGGER.debug("public boolean usesLocalFiles()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        LOGGER.debug("public boolean usesLocalFilePerTable()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        LOGGER.debug("public boolean supportsMixedCaseIdentifiers()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        LOGGER.debug("public boolean storesUpperCaseIdentifiers()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        LOGGER.debug("public boolean storesLowerCaseIdentifiers()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        LOGGER.debug("public boolean storesMixedCaseIdentifiers()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        LOGGER.debug("public boolean supportsMixedCaseQuotedIdentifiers()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        LOGGER.debug("public boolean storesUpperCaseQuotedIdentifiers()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        LOGGER.debug("public boolean storesLowerCaseQuotedIdentifiers()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        LOGGER.debug("public boolean storesMixedCaseQuotedIdentifiers()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        LOGGER.debug("public String getIdentifierQuoteString()");
        this.throwExceptionIfConnectionIsClosed();
        return "`";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        LOGGER.debug("public String getSQLKeywords()");
        this.throwExceptionIfConnectionIsClosed();
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        LOGGER.debug("public String getNumericFunctions()");
        this.throwExceptionIfConnectionIsClosed();
        return NUMERIC_FUNCTIONS;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        LOGGER.debug("public String getStringFunctions()");
        this.throwExceptionIfConnectionIsClosed();
        return STRING_FUNCTIONS;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        LOGGER.debug("public String getSystemFunctions()");
        this.throwExceptionIfConnectionIsClosed();
        return SYSTEM_FUNCTIONS;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        LOGGER.debug("public String getTimeDateFunctions()");
        this.throwExceptionIfConnectionIsClosed();
        return TIME_DATE_FUNCTIONS;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        LOGGER.debug("public String getSearchStringEscape()");
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        LOGGER.debug("public String getExtraNameCharacters()");
        this.throwExceptionIfConnectionIsClosed();
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        LOGGER.debug("public boolean supportsAlterTableWithAddColumn()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        LOGGER.debug("public boolean supportsAlterTableWithDropColumn()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        LOGGER.debug("public boolean supportsColumnAliasing()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        LOGGER.debug("public boolean nullPlusNonNullIsNull()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        LOGGER.debug("public boolean supportsConvert()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return ConverterHelper.isConversionSupported(fromType, toType);
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        LOGGER.debug("public boolean supportsTableCorrelationNames()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        LOGGER.debug("public boolean supportsDifferentTableCorrelationNames()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        LOGGER.debug("public boolean supportsExpressionsInOrderBy()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        LOGGER.debug("public boolean supportsOrderByUnrelated()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        LOGGER.debug("public boolean supportsGroupBy()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        LOGGER.debug("public boolean supportsGroupByUnrelated()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        LOGGER.debug("public boolean supportsGroupByBeyondSelect()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        LOGGER.debug("public boolean supportsLikeEscapeClause()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        LOGGER.debug("public boolean supportsMultipleResultSets()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        LOGGER.debug("public boolean supportsMultipleTransactions()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        LOGGER.debug("public boolean supportsNonNullableColumns()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        LOGGER.debug("public boolean supportsMinimumSQLGrammar()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        LOGGER.debug("public boolean supportsCoreSQLGrammar()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        LOGGER.debug("public boolean supportsExtendedSQLGrammar()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        LOGGER.debug("public boolean supportsANSI92EntryLevelSQL()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        LOGGER.debug("public boolean supportsANSI92IntermediateSQL()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        LOGGER.debug("public boolean supportsANSI92FullSQL()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        LOGGER.debug("public boolean supportsIntegrityEnhancementFacility()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        LOGGER.debug("public boolean supportsOuterJoins()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        LOGGER.debug("public boolean supportsFullOuterJoins()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        LOGGER.debug("public boolean supportsLimitedOuterJoins()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        LOGGER.debug("public String getSchemaTerm()");
        this.throwExceptionIfConnectionIsClosed();
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        LOGGER.debug("public String getProcedureTerm()");
        this.throwExceptionIfConnectionIsClosed();
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        LOGGER.debug("public String getCatalogTerm()");
        this.throwExceptionIfConnectionIsClosed();
        return "catalog";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        LOGGER.debug("public boolean isCatalogAtStart()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        LOGGER.debug("public String getCatalogSeparator()");
        this.throwExceptionIfConnectionIsClosed();
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        LOGGER.debug("public boolean supportsSchemasInDataManipulation()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        LOGGER.debug("public boolean supportsSchemasInProcedureCalls()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        LOGGER.debug("public boolean supportsSchemasInTableDefinitions()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        LOGGER.debug("public boolean supportsSchemasInIndexDefinitions()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        LOGGER.debug("public boolean supportsSchemasInPrivilegeDefinitions()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        LOGGER.debug("public boolean supportsCatalogsInDataManipulation()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        LOGGER.debug("public boolean supportsCatalogsInProcedureCalls()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        LOGGER.debug("public boolean supportsCatalogsInTableDefinitions()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        LOGGER.debug("public boolean supportsCatalogsInIndexDefinitions()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        LOGGER.debug("public boolean supportsCatalogsInPrivilegeDefinitions()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        LOGGER.debug("public boolean supportsPositionedDelete()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        LOGGER.debug("public boolean supportsPositionedUpdate()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        LOGGER.debug("public boolean supportsSelectForUpdate()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        LOGGER.debug("public boolean supportsStoredProcedures()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        LOGGER.debug("public boolean supportsSubqueriesInComparisons()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        LOGGER.debug("public boolean supportsSubqueriesInExists()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        LOGGER.debug("public boolean supportsSubqueriesInIns()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        LOGGER.debug("public boolean supportsSubqueriesInQuantifieds()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        LOGGER.debug("public boolean supportsCorrelatedSubqueries()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        LOGGER.debug("public boolean supportsUnion()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        LOGGER.debug("public boolean supportsUnionAll()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        LOGGER.debug("public boolean supportsOpenCursorsAcrossCommit()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        LOGGER.debug("public boolean supportsOpenCursorsAcrossRollback()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        LOGGER.debug("public boolean supportsOpenStatementsAcrossCommit()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        LOGGER.debug("public boolean supportsOpenStatementsAcrossRollback()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        LOGGER.debug("public int getMaxBinaryLiteralLength()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        LOGGER.debug("public int getMaxCharLiteralLength()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        LOGGER.debug("public int getMaxColumnNameLength()");
        this.throwExceptionIfConnectionIsClosed();
        return MAX_NAME_LENGTH;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        LOGGER.debug("public int getMaxColumnsInGroupBy()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        LOGGER.debug("public int getMaxColumnsInIndex()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        LOGGER.debug("public int getMaxColumnsInOrderBy()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        LOGGER.debug("public int getMaxColumnsInSelect()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        LOGGER.debug("public int getMaxColumnsInTable()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        LOGGER.debug("public int getMaxConnections()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        LOGGER.debug("public int getMaxCursorNameLength()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        LOGGER.debug("public int getMaxIndexLength()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        LOGGER.debug("public int getMaxSchemaNameLength()");
        this.throwExceptionIfConnectionIsClosed();
        return MAX_NAME_LENGTH;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        LOGGER.debug("public int getMaxProcedureNameLength()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        LOGGER.debug("public int getMaxCatalogNameLength()");
        this.throwExceptionIfConnectionIsClosed();
        return MAX_NAME_LENGTH;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        LOGGER.debug("public int getMaxRowSize()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        LOGGER.debug("public boolean doesMaxRowSizeIncludeBlobs()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        LOGGER.debug("public int getMaxStatementLength()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        LOGGER.debug("public int getMaxStatements()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        LOGGER.debug("public int getMaxTableNameLength()");
        this.throwExceptionIfConnectionIsClosed();
        return MAX_NAME_LENGTH;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        LOGGER.debug("public int getMaxTablesInSelect()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        LOGGER.debug("public int getMaxUserNameLength()");
        this.throwExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        LOGGER.debug("public int getDefaultTransactionIsolation()");
        this.throwExceptionIfConnectionIsClosed();
        return 4;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        LOGGER.debug("public boolean supportsTransactions()");
        this.throwExceptionIfConnectionIsClosed();
        return !this.session.getConnectionContext().getIgnoreTransactions();
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        LOGGER.debug("public boolean supportsTransactionIsolationLevel(int level = {})", level);
        this.throwExceptionIfConnectionIsClosed();
        return level == 4;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        LOGGER.debug("public boolean supportsDataDefinitionAndDataManipulationTransactions()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        LOGGER.debug("public boolean supportsDataManipulationTransactionsOnly()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        LOGGER.debug("public boolean dataDefinitionCausesTransactionCommit()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        LOGGER.debug("public boolean dataDefinitionIgnoredInTransactions()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        LOGGER.debug("public long getMaxLogicalLobSize()");
        this.throwExceptionIfConnectionIsClosed();
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        LOGGER.debug("public boolean supportsRefCursors()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsSharding() throws SQLException {
        LOGGER.debug("public boolean supportsSharding()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        LOGGER.debug("public ResultSet getProcedures(String catalog = {}, String schemaPattern = {}, String procedureNamePattern = {})", catalog, schemaPattern, procedureNamePattern);
        this.throwExceptionIfConnectionIsClosed();
        return new DatabricksResultSet(new StatementStatus().setState(StatementState.SUCCEEDED), new StatementId("getprocedures-metadata"), Arrays.asList("PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "NUM_INPUT_PARAMS", "NUM_OUTPUT_PARAMS", "NUM_RESULT_SETS", "REMARKS", "PROCEDURE_TYPE", "SPECIFIC_NAME"), Arrays.asList("VARCHAR", "VARCHAR", "VARCHAR", "INTEGER", "INTEGER", "INTEGER", "VARCHAR", "SMALLINT", "VARCHAR"), new int[]{12, 12, 12, 4, 4, 4, 12, 5, 12}, new int[]{128, 128, 128, 10, 10, 10, 254, 5, 128}, new int[]{1, 1, 0, 1, 1, 1, 1, 1, 0}, new Object[0][0], StatementType.METADATA);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        LOGGER.debug("public ResultSet getProcedureColumns(String catalog = {}, String schemaPattern = {}, String procedureNamePattern = {}, String columnNamePattern = {})", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        this.throwExceptionIfConnectionIsClosed();
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.PROCEDURE_COLUMNS_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_PROCEDURES_COLUMNS);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (tableNamePattern != null) {
            tableNamePattern = tableNamePattern.toLowerCase();
        }
        LOGGER.debug("public ResultSet getTables(String catalog = {}, String schemaPattern = {}, String tableNamePattern = {}, String[] types = {})", catalog, schemaPattern, tableNamePattern, types);
        this.throwExceptionIfConnectionIsClosed();
        return this.session.getDatabricksMetadataClient().listTables(this.session, catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        LOGGER.debug("public ResultSet getSchemas()");
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        LOGGER.debug("public ResultSet getCatalogs()");
        this.throwExceptionIfConnectionIsClosed();
        return this.session.getDatabricksMetadataClient().listCatalogs(this.session);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        LOGGER.debug("public ResultSet getTableTypes()");
        this.throwExceptionIfConnectionIsClosed();
        return this.session.getDatabricksMetadataClient().listTableTypes(this.session);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getColumns(String catalog = {}, String schemaPattern = {}, String tableNamePattern = {}, String columnNamePattern = {})", catalog, schemaPattern, tableNamePattern, columnNamePattern));
        this.throwExceptionIfConnectionIsClosed();
        return this.session.getDatabricksMetadataClient().listColumns(this.session, catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getColumnPrivileges(String catalog = {}, String schema = {}, String table = {}, String columnNamePattern = {})", catalog, schema, table, columnNamePattern));
        this.throwExceptionIfConnectionIsClosed();
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.COLUMN_PRIVILEGES_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_COLUMN_PRIVILEGES);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getTablePrivileges(String catalog = {}, String schemaPattern = {}, String tableNamePattern = {})", catalog, schemaPattern, tableNamePattern));
        this.throwExceptionIfConnectionIsClosed();
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.TABLE_PRIVILEGES_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_TABLE_PRIVILEGES);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        LOGGER.debug("public ResultSet getBestRowIdentifier(String catalog = {}, String schema = {}, String table = {}, int scope = {}, boolean nullable = {})", catalog, schema, table, scope, nullable);
        switch (scope) {
            case 0: 
            case 1: 
            case 2: {
                return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.BEST_ROW_IDENTIFIER_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_BEST_ROW_IDENTIFIER);
            }
        }
        throw new DatabricksSQLException("Unknown scope value: " + scope, DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getVersionColumns(String catalog = {}, String schema = {}, String table = {})", catalog, schema, table));
        this.throwExceptionIfConnectionIsClosed();
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.VERSION_COLUMNS_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_VERSION_COLUMNS);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getPrimaryKeys(String catalog = {}, String schema = {}, String table = {})", catalog, schema, table));
        this.throwExceptionIfConnectionIsClosed();
        return this.session.getDatabricksMetadataClient().listPrimaryKeys(this.session, catalog, schema, table);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getImportedKeys(String catalog = {}, String schema = {}, String table = {})", catalog, schema, table));
        this.throwExceptionIfConnectionIsClosed();
        return this.session.getDatabricksMetadataClient().listImportedKeys(this.session, catalog, schema, table);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getExportedKeys(String catalog = {}, String schema = {}, String table = {})", catalog, schema, table));
        this.throwExceptionIfConnectionIsClosed();
        return this.session.getDatabricksMetadataClient().listExportedKeys(this.session, catalog, schema, table);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getCrossReference(String parentCatalog = {}, String parentSchema = {}, String parentTable = {}, String foreignCatalog = {}, String foreignSchema = {}, String foreignTable = {})", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable));
        this.throwExceptionIfConnectionIsClosed();
        if (parentTable == null && foreignTable == null) {
            throw new DatabricksSQLException("Invalid argument: foreignTable and parentTableName are both null", DatabricksDriverErrorCode.INVALID_STATE);
        }
        return this.session.getDatabricksMetadataClient().listCrossReferences(this.session, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        LOGGER.debug("public ResultSet getTypeInfo()");
        this.throwExceptionIfConnectionIsClosed();
        return this.session.getDatabricksMetadataClient().listTypeInfo(this.session);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getIndexInfo(String catalog = {}, String schema = {}, String table = {}, boolean unique = {}, boolean approximate = {})", catalog, schema, table, unique, approximate));
        this.throwExceptionIfConnectionIsClosed();
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.INDEX_INFO_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_INDEX_INFO);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        LOGGER.debug("public boolean supportsResultSetType(int type = {})", type);
        this.throwExceptionIfConnectionIsClosed();
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        LOGGER.debug(String.format("public boolean supportsResultSetConcurrency(int type = {}, int concurrency = {})", type, concurrency));
        this.throwExceptionIfConnectionIsClosed();
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        LOGGER.debug("public boolean ownUpdatesAreVisible(int type = {})", type);
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        LOGGER.debug("public boolean ownDeletesAreVisible(int type = {})", type);
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        LOGGER.debug("public boolean ownInsertsAreVisible(int type = {})", type);
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        LOGGER.debug("public boolean othersUpdatesAreVisible(int type = {})", type);
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        LOGGER.debug("public boolean othersDeletesAreVisible(int type = {})", type);
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        LOGGER.debug("public boolean updatesAreDetected(int type = {})", type);
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        LOGGER.debug("public boolean deletesAreDetected(int type = {})", type);
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        LOGGER.debug("public boolean insertsAreDetected(int type = {})", type);
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        LOGGER.debug("public boolean supportsBatchUpdates()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getUDTs(String catalog = {}, String schemaPattern = {}, String typeNamePattern = {}, int[] types = {})", catalog, schemaPattern, typeNamePattern, Arrays.toString(types)));
        this.throwExceptionIfConnectionIsClosed();
        return new DatabricksResultSet(new StatementStatus().setState(StatementState.SUCCEEDED), new StatementId("getudts-metadata"), Arrays.asList("TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"), Arrays.asList("VARCHAR", "VARCHAR", "VARCHAR", "VARCHAR", "INTEGER", "VARCHAR", "SMALLINT"), new int[]{12, 12, 12, 12, 4, 12, 5}, new int[]{128, 128, 128, 128, 10, 254, 5}, new int[]{1, 1, 0, 0, 0, 1, 1}, new String[0][0], StatementType.METADATA);
    }

    @Override
    public Connection getConnection() throws SQLException {
        LOGGER.debug("public Connection getConnection()");
        return this.connection.getConnection();
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        LOGGER.debug("public boolean supportsSavepoints()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        LOGGER.debug("public boolean supportsNamedParameters()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        LOGGER.debug("public boolean supportsMultipleOpenResults()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        LOGGER.debug("public boolean supportsGetGeneratedKeys()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getSuperTypes(String catalog = {}, String schemaPattern = {}, String typeNamePattern = {})", catalog, schemaPattern, typeNamePattern));
        this.throwExceptionIfConnectionIsClosed();
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.SUPER_TYPES_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_SUPER_TYPES);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getSuperTables(String catalog = {}, String schemaPattern = {}, String tableNamePattern = {})", catalog, schemaPattern, tableNamePattern));
        this.throwExceptionIfConnectionIsClosed();
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.SUPER_TABLES_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_SUPER_TABLES);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        LOGGER.debug("public ResultSet getAttributes(String catalog = {}, String schemaPattern = {}, String typeNamePattern = {}, String attributeNamePattern = {})", catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.ATTRIBUTES_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_ATTRIBUTES);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        LOGGER.debug("public boolean supportsResultSetHoldability(int holdability = {})", holdability);
        this.throwExceptionIfConnectionIsClosed();
        return holdability == 2;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        LOGGER.debug("public int getResultSetHoldability()");
        this.throwExceptionIfConnectionIsClosed();
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() {
        LOGGER.debug("public int getDatabaseMajorVersion()");
        return 3;
    }

    @Override
    public int getDatabaseMinorVersion() {
        LOGGER.debug("public int getDatabaseMinorVersion()");
        return 1;
    }

    @Override
    public int getJDBCMajorVersion() {
        LOGGER.debug("public int getJDBCMajorVersion()");
        return DriverUtil.getJDBCMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() {
        LOGGER.debug("public int getJDBCMinorVersion()");
        return DriverUtil.getJDBCMinorVersion();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        LOGGER.debug("public int getSQLStateType()");
        this.throwExceptionIfConnectionIsClosed();
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        LOGGER.debug("public boolean locatorsUpdateCopy()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        LOGGER.debug("public boolean supportsStatementPooling()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        LOGGER.debug("public RowIdLifetime getRowIdLifetime()");
        this.throwExceptionIfConnectionIsClosed();
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        LOGGER.debug("public ResultSet getSchemas(String catalog = {}, String schemaPattern = {})", catalog, schemaPattern);
        this.throwExceptionIfConnectionIsClosed();
        return this.session.getDatabricksMetadataClient().listSchemas(this.session, catalog, schemaPattern);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        LOGGER.debug("public boolean supportsStoredFunctionsUsingCallSyntax()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        LOGGER.debug("public boolean autoCommitFailureClosesAllResultSets()");
        this.throwExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        LOGGER.debug("public ResultSet getClientInfoProperties()");
        this.throwExceptionIfConnectionIsClosed();
        return ResultConstants.CLIENT_INFO_PROPERTIES_RESULT;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        LOGGER.debug("public ResultSet getFunctions(String catalog = {}, String schemaPattern = {}, String functionNamePattern = {})", catalog, schemaPattern, functionNamePattern);
        this.throwExceptionIfConnectionIsClosed();
        try {
            if (WildcardUtil.isNullOrEmpty(functionNamePattern)) {
                functionNamePattern = "%";
            }
            return this.session.getDatabricksMetadataClient().listFunctions(this.session, catalog, schemaPattern, functionNamePattern);
        }
        catch (Exception e) {
            LOGGER.error(e, "Unable to fetch functions, returning empty result set {}", e);
            return this.metadataResultSetBuilder.getFunctionsResult(catalog, List.of());
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getFunctionColumns(String catalog = {}, String schemaPattern = {}, String functionNamePattern = {}, String columnNamePattern = {})", catalog, schemaPattern, functionNamePattern, columnNamePattern));
        this.throwExceptionIfConnectionIsClosed();
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.FUNCTION_COLUMNS_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_FUNCTION_COLUMNS);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        LOGGER.debug(String.format("public ResultSet getPseudoColumns(String catalog = {}, String schemaPattern = {}, String tableNamePattern = {}, String columnNamePattern = {})", catalog, schemaPattern, tableNamePattern, columnNamePattern));
        this.throwExceptionIfConnectionIsClosed();
        return this.metadataResultSetBuilder.getResultSetWithGivenRowsAndColumns(MetadataResultConstants.PSEUDO_COLUMNS_COLUMNS, new ArrayList<List<Object>>(), "metadata-statement", CommandName.GET_PSEUDO_COLUMNS);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        LOGGER.debug("public boolean generatedKeyAlwaysReturned()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        LOGGER.debug("public <T> T unwrap(Class<T> iface = {})", iface);
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new DatabricksSQLException("Cannot unwrap to " + iface.getName(), DatabricksDriverErrorCode.INVALID_STATE);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        LOGGER.debug("public boolean isWrapperFor(Class<?> iface = {})", iface);
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    private void throwExceptionIfConnectionIsClosed() throws SQLException {
        LOGGER.debug("private void throwExceptionIfConnectionIsClosed()");
        if (!this.connection.getSession().isOpen()) {
            throw new DatabricksSQLException("Connection closed!", DatabricksDriverErrorCode.CONNECTION_CLOSED);
        }
    }
}

