/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.dashboards;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.dashboards.CreateDashboardRequest;
import com.databricks.internal.sdk.service.dashboards.CreateScheduleRequest;
import com.databricks.internal.sdk.service.dashboards.CreateSubscriptionRequest;
import com.databricks.internal.sdk.service.dashboards.Dashboard;
import com.databricks.internal.sdk.service.dashboards.DeleteScheduleRequest;
import com.databricks.internal.sdk.service.dashboards.DeleteSubscriptionRequest;
import com.databricks.internal.sdk.service.dashboards.GetDashboardRequest;
import com.databricks.internal.sdk.service.dashboards.GetPublishedDashboardRequest;
import com.databricks.internal.sdk.service.dashboards.GetScheduleRequest;
import com.databricks.internal.sdk.service.dashboards.GetSubscriptionRequest;
import com.databricks.internal.sdk.service.dashboards.LakeviewImpl;
import com.databricks.internal.sdk.service.dashboards.LakeviewService;
import com.databricks.internal.sdk.service.dashboards.ListDashboardsRequest;
import com.databricks.internal.sdk.service.dashboards.ListDashboardsResponse;
import com.databricks.internal.sdk.service.dashboards.ListSchedulesRequest;
import com.databricks.internal.sdk.service.dashboards.ListSchedulesResponse;
import com.databricks.internal.sdk.service.dashboards.ListSubscriptionsRequest;
import com.databricks.internal.sdk.service.dashboards.ListSubscriptionsResponse;
import com.databricks.internal.sdk.service.dashboards.MigrateDashboardRequest;
import com.databricks.internal.sdk.service.dashboards.PublishRequest;
import com.databricks.internal.sdk.service.dashboards.PublishedDashboard;
import com.databricks.internal.sdk.service.dashboards.Schedule;
import com.databricks.internal.sdk.service.dashboards.Subscription;
import com.databricks.internal.sdk.service.dashboards.TrashDashboardRequest;
import com.databricks.internal.sdk.service.dashboards.UnpublishDashboardRequest;
import com.databricks.internal.sdk.service.dashboards.UpdateDashboardRequest;
import com.databricks.internal.sdk.service.dashboards.UpdateScheduleRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class LakeviewAPI {
    private static final Logger LOG = LoggerFactory.getLogger(LakeviewAPI.class);
    private final LakeviewService impl;

    public LakeviewAPI(ApiClient apiClient) {
        this.impl = new LakeviewImpl(apiClient);
    }

    public LakeviewAPI(LakeviewService mock) {
        this.impl = mock;
    }

    public Dashboard create(CreateDashboardRequest request) {
        return this.impl.create(request);
    }

    public Schedule createSchedule(CreateScheduleRequest request) {
        return this.impl.createSchedule(request);
    }

    public Subscription createSubscription(CreateSubscriptionRequest request) {
        return this.impl.createSubscription(request);
    }

    public void deleteSchedule(String dashboardId, String scheduleId) {
        this.deleteSchedule(new DeleteScheduleRequest().setDashboardId(dashboardId).setScheduleId(scheduleId));
    }

    public void deleteSchedule(DeleteScheduleRequest request) {
        this.impl.deleteSchedule(request);
    }

    public void deleteSubscription(String dashboardId, String scheduleId, String subscriptionId) {
        this.deleteSubscription(new DeleteSubscriptionRequest().setDashboardId(dashboardId).setScheduleId(scheduleId).setSubscriptionId(subscriptionId));
    }

    public void deleteSubscription(DeleteSubscriptionRequest request) {
        this.impl.deleteSubscription(request);
    }

    public Dashboard get(String dashboardId) {
        return this.get(new GetDashboardRequest().setDashboardId(dashboardId));
    }

    public Dashboard get(GetDashboardRequest request) {
        return this.impl.get(request);
    }

    public PublishedDashboard getPublished(String dashboardId) {
        return this.getPublished(new GetPublishedDashboardRequest().setDashboardId(dashboardId));
    }

    public PublishedDashboard getPublished(GetPublishedDashboardRequest request) {
        return this.impl.getPublished(request);
    }

    public Schedule getSchedule(String dashboardId, String scheduleId) {
        return this.getSchedule(new GetScheduleRequest().setDashboardId(dashboardId).setScheduleId(scheduleId));
    }

    public Schedule getSchedule(GetScheduleRequest request) {
        return this.impl.getSchedule(request);
    }

    public Subscription getSubscription(String dashboardId, String scheduleId, String subscriptionId) {
        return this.getSubscription(new GetSubscriptionRequest().setDashboardId(dashboardId).setScheduleId(scheduleId).setSubscriptionId(subscriptionId));
    }

    public Subscription getSubscription(GetSubscriptionRequest request) {
        return this.impl.getSubscription(request);
    }

    public Iterable<Dashboard> list(ListDashboardsRequest request) {
        return new Paginator(request, this.impl::list, ListDashboardsResponse::getDashboards, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Schedule> listSchedules(String dashboardId) {
        return this.listSchedules(new ListSchedulesRequest().setDashboardId(dashboardId));
    }

    public Iterable<Schedule> listSchedules(ListSchedulesRequest request) {
        return new Paginator(request, this.impl::listSchedules, ListSchedulesResponse::getSchedules, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Subscription> listSubscriptions(String dashboardId, String scheduleId) {
        return this.listSubscriptions(new ListSubscriptionsRequest().setDashboardId(dashboardId).setScheduleId(scheduleId));
    }

    public Iterable<Subscription> listSubscriptions(ListSubscriptionsRequest request) {
        return new Paginator(request, this.impl::listSubscriptions, ListSubscriptionsResponse::getSubscriptions, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Dashboard migrate(MigrateDashboardRequest request) {
        return this.impl.migrate(request);
    }

    public PublishedDashboard publish(PublishRequest request) {
        return this.impl.publish(request);
    }

    public void trash(String dashboardId) {
        this.trash(new TrashDashboardRequest().setDashboardId(dashboardId));
    }

    public void trash(TrashDashboardRequest request) {
        this.impl.trash(request);
    }

    public void unpublish(String dashboardId) {
        this.unpublish(new UnpublishDashboardRequest().setDashboardId(dashboardId));
    }

    public void unpublish(UnpublishDashboardRequest request) {
        this.impl.unpublish(request);
    }

    public Dashboard update(UpdateDashboardRequest request) {
        return this.impl.update(request);
    }

    public Schedule updateSchedule(UpdateScheduleRequest request) {
        return this.impl.updateSchedule(request);
    }

    public LakeviewService impl() {
        return this.impl;
    }
}

