/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.compute;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.compute.CreateResponse;
import com.databricks.internal.sdk.service.compute.DeleteGlobalInitScriptRequest;
import com.databricks.internal.sdk.service.compute.GetGlobalInitScriptRequest;
import com.databricks.internal.sdk.service.compute.GlobalInitScriptCreateRequest;
import com.databricks.internal.sdk.service.compute.GlobalInitScriptDetails;
import com.databricks.internal.sdk.service.compute.GlobalInitScriptDetailsWithContent;
import com.databricks.internal.sdk.service.compute.GlobalInitScriptUpdateRequest;
import com.databricks.internal.sdk.service.compute.GlobalInitScriptsImpl;
import com.databricks.internal.sdk.service.compute.GlobalInitScriptsService;
import com.databricks.internal.sdk.service.compute.ListGlobalInitScriptsResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class GlobalInitScriptsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalInitScriptsAPI.class);
    private final GlobalInitScriptsService impl;

    public GlobalInitScriptsAPI(ApiClient apiClient) {
        this.impl = new GlobalInitScriptsImpl(apiClient);
    }

    public GlobalInitScriptsAPI(GlobalInitScriptsService mock) {
        this.impl = mock;
    }

    public CreateResponse create(GlobalInitScriptCreateRequest request) {
        return this.impl.create(request);
    }

    public void delete(String scriptId) {
        this.delete(new DeleteGlobalInitScriptRequest().setScriptId(scriptId));
    }

    public void delete(DeleteGlobalInitScriptRequest request) {
        this.impl.delete(request);
    }

    public GlobalInitScriptDetailsWithContent get(String scriptId) {
        return this.get(new GetGlobalInitScriptRequest().setScriptId(scriptId));
    }

    public GlobalInitScriptDetailsWithContent get(GetGlobalInitScriptRequest request) {
        return this.impl.get(request);
    }

    public Iterable<GlobalInitScriptDetails> list() {
        return new Paginator(null, v -> this.impl.list(), ListGlobalInitScriptsResponse::getScripts, response -> null);
    }

    public void update(GlobalInitScriptUpdateRequest request) {
        this.impl.update(request);
    }

    public GlobalInitScriptsService impl() {
        return this.impl;
    }
}

