/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.apps;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.service.apps.App;
import com.databricks.internal.sdk.service.apps.AppDeployment;
import com.databricks.internal.sdk.service.apps.AppDeploymentState;
import com.databricks.internal.sdk.service.apps.AppPermissions;
import com.databricks.internal.sdk.service.apps.AppPermissionsRequest;
import com.databricks.internal.sdk.service.apps.AppUpdate;
import com.databricks.internal.sdk.service.apps.AppUpdateUpdateStatusUpdateState;
import com.databricks.internal.sdk.service.apps.AppsImpl;
import com.databricks.internal.sdk.service.apps.AppsService;
import com.databricks.internal.sdk.service.apps.AsyncUpdateAppRequest;
import com.databricks.internal.sdk.service.apps.ComputeState;
import com.databricks.internal.sdk.service.apps.CreateAppDeploymentRequest;
import com.databricks.internal.sdk.service.apps.CreateAppRequest;
import com.databricks.internal.sdk.service.apps.DeleteAppRequest;
import com.databricks.internal.sdk.service.apps.GetAppDeploymentRequest;
import com.databricks.internal.sdk.service.apps.GetAppPermissionLevelsRequest;
import com.databricks.internal.sdk.service.apps.GetAppPermissionLevelsResponse;
import com.databricks.internal.sdk.service.apps.GetAppPermissionsRequest;
import com.databricks.internal.sdk.service.apps.GetAppRequest;
import com.databricks.internal.sdk.service.apps.GetAppUpdateRequest;
import com.databricks.internal.sdk.service.apps.ListAppDeploymentsRequest;
import com.databricks.internal.sdk.service.apps.ListAppDeploymentsResponse;
import com.databricks.internal.sdk.service.apps.ListAppsRequest;
import com.databricks.internal.sdk.service.apps.ListAppsResponse;
import com.databricks.internal.sdk.service.apps.StartAppRequest;
import com.databricks.internal.sdk.service.apps.StopAppRequest;
import com.databricks.internal.sdk.service.apps.UpdateAppRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.sdk.support.Wait;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

@Generated
public class AppsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AppsAPI.class);
    private final AppsService impl;

    public AppsAPI(ApiClient apiClient) {
        this.impl = new AppsImpl(apiClient);
    }

    public AppsAPI(AppsService mock) {
        this.impl = mock;
    }

    public App waitGetAppActive(String name) throws TimeoutException {
        return this.waitGetAppActive(name, Duration.ofMinutes(20L), null);
    }

    public App waitGetAppActive(String name, Duration timeout, Consumer<App> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<ComputeState> targetStates = Arrays.asList(ComputeState.ACTIVE);
        List<ComputeState> failureStates = Arrays.asList(ComputeState.ERROR, ComputeState.STOPPED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            App poll = this.get(new GetAppRequest().setName(name));
            ComputeState status = poll.getComputeStatus().getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getComputeStatus() != null) {
                statusMessage = poll.getComputeStatus().getMessage();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach ACTIVE, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("name=%s", name);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public AppUpdate waitGetUpdateAppSucceeded(String appName) throws TimeoutException {
        return this.waitGetUpdateAppSucceeded(appName, Duration.ofMinutes(20L), null);
    }

    public AppUpdate waitGetUpdateAppSucceeded(String appName, Duration timeout, Consumer<AppUpdate> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<AppUpdateUpdateStatusUpdateState> targetStates = Arrays.asList(AppUpdateUpdateStatusUpdateState.SUCCEEDED);
        List<AppUpdateUpdateStatusUpdateState> failureStates = Arrays.asList(AppUpdateUpdateStatusUpdateState.FAILED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            AppUpdate poll = this.getUpdate(new GetAppUpdateRequest().setAppName(appName));
            AppUpdateUpdateStatusUpdateState status = poll.getStatus().getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getStatus() != null) {
                statusMessage = poll.getStatus().getMessage();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach SUCCEEDED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("appName=%s", appName);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public AppDeployment waitGetDeploymentAppSucceeded(String appName, String deploymentId) throws TimeoutException {
        return this.waitGetDeploymentAppSucceeded(appName, deploymentId, Duration.ofMinutes(20L), null);
    }

    public AppDeployment waitGetDeploymentAppSucceeded(String appName, String deploymentId, Duration timeout, Consumer<AppDeployment> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<AppDeploymentState> targetStates = Arrays.asList(AppDeploymentState.SUCCEEDED);
        List<AppDeploymentState> failureStates = Arrays.asList(AppDeploymentState.FAILED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            AppDeployment poll = this.getDeployment(new GetAppDeploymentRequest().setAppName(appName).setDeploymentId(deploymentId));
            AppDeploymentState status = poll.getStatus().getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getStatus() != null) {
                statusMessage = poll.getStatus().getMessage();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach SUCCEEDED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("appName=%s, deploymentId=%s", appName, deploymentId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public App waitGetAppStopped(String name) throws TimeoutException {
        return this.waitGetAppStopped(name, Duration.ofMinutes(20L), null);
    }

    public App waitGetAppStopped(String name, Duration timeout, Consumer<App> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<ComputeState> targetStates = Arrays.asList(ComputeState.STOPPED);
        List<ComputeState> failureStates = Arrays.asList(ComputeState.ERROR);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            App poll = this.get(new GetAppRequest().setName(name));
            ComputeState status = poll.getComputeStatus().getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getComputeStatus() != null) {
                statusMessage = poll.getComputeStatus().getMessage();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach STOPPED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("name=%s", name);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<App, App> create(CreateAppRequest request) {
        App response = this.impl.create(request);
        return new Wait<App, App>((timeout, callback) -> this.waitGetAppActive(response.getName(), timeout, callback), response);
    }

    public Wait<AppUpdate, AppUpdate> createUpdate(AsyncUpdateAppRequest request) {
        AppUpdate response = this.impl.createUpdate(request);
        return new Wait<AppUpdate, AppUpdate>((timeout, callback) -> this.waitGetUpdateAppSucceeded(request.getAppName(), timeout, callback), response);
    }

    public App delete(String name) {
        return this.delete(new DeleteAppRequest().setName(name));
    }

    public App delete(DeleteAppRequest request) {
        return this.impl.delete(request);
    }

    public Wait<AppDeployment, AppDeployment> deploy(CreateAppDeploymentRequest request) {
        AppDeployment response = this.impl.deploy(request);
        return new Wait<AppDeployment, AppDeployment>((timeout, callback) -> this.waitGetDeploymentAppSucceeded(request.getAppName(), response.getDeploymentId(), timeout, callback), response);
    }

    public App get(String name) {
        return this.get(new GetAppRequest().setName(name));
    }

    public App get(GetAppRequest request) {
        return this.impl.get(request);
    }

    public AppDeployment getDeployment(String appName, String deploymentId) {
        return this.getDeployment(new GetAppDeploymentRequest().setAppName(appName).setDeploymentId(deploymentId));
    }

    public AppDeployment getDeployment(GetAppDeploymentRequest request) {
        return this.impl.getDeployment(request);
    }

    public GetAppPermissionLevelsResponse getPermissionLevels(String appName) {
        return this.getPermissionLevels(new GetAppPermissionLevelsRequest().setAppName(appName));
    }

    public GetAppPermissionLevelsResponse getPermissionLevels(GetAppPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public AppPermissions getPermissions(String appName) {
        return this.getPermissions(new GetAppPermissionsRequest().setAppName(appName));
    }

    public AppPermissions getPermissions(GetAppPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public AppUpdate getUpdate(String appName) {
        return this.getUpdate(new GetAppUpdateRequest().setAppName(appName));
    }

    public AppUpdate getUpdate(GetAppUpdateRequest request) {
        return this.impl.getUpdate(request);
    }

    public Iterable<App> list(ListAppsRequest request) {
        return new Paginator(request, this.impl::list, ListAppsResponse::getApps, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<AppDeployment> listDeployments(String appName) {
        return this.listDeployments(new ListAppDeploymentsRequest().setAppName(appName));
    }

    public Iterable<AppDeployment> listDeployments(ListAppDeploymentsRequest request) {
        return new Paginator(request, this.impl::listDeployments, ListAppDeploymentsResponse::getAppDeployments, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public AppPermissions setPermissions(AppPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public Wait<App, App> start(StartAppRequest request) {
        App response = this.impl.start(request);
        return new Wait<App, App>((timeout, callback) -> this.waitGetAppActive(response.getName(), timeout, callback), response);
    }

    public Wait<App, App> stop(StopAppRequest request) {
        App response = this.impl.stop(request);
        return new Wait<App, App>((timeout, callback) -> this.waitGetAppStopped(response.getName(), timeout, callback), response);
    }

    public App update(UpdateAppRequest request) {
        return this.impl.update(request);
    }

    public AppPermissions updatePermissions(AppPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public AppsService impl() {
        return this.impl;
    }
}

